/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.kafka.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import net.tirasa.connid.bundles.kafka.serialization.AttributeDeserializer;
import net.tirasa.connid.bundles.kafka.serialization.ConnectorObjectDeserializer;
import net.tirasa.connid.bundles.kafka.serialization.SyncTokenDeserializer;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.Uid;

public class SyncDeltaJacksonDeserializer
extends JsonDeserializer<SyncDelta> {
    private static final AttributeDeserializer ATTR_DESERIALIZER = new AttributeDeserializer();
    private static final SyncTokenDeserializer SYNC_TOKEN_DESERIALIZER = new SyncTokenDeserializer();
    private static final ConnectorObjectDeserializer CONNECTOR_OBJECT_DESERIALIZER = new ConnectorObjectDeserializer();

    public SyncDelta deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonParser parser;
        ObjectNode tree = (ObjectNode)jp.readValueAsTree();
        SyncDeltaBuilder builder = new SyncDeltaBuilder();
        if (tree.has("objectClass")) {
            builder.setObjectClass(new ObjectClass(tree.get("objectClass").get("type").asText()));
        }
        if (tree.has("uid")) {
            parser = tree.get("uid").traverse();
            parser.setCodec(jp.getCodec());
            builder.setUid((Uid)ATTR_DESERIALIZER.deserialize(parser, ctx));
        }
        if (tree.has("previousUid") && !tree.get("previousUid").isNull()) {
            parser = tree.get("previousUid").traverse();
            parser.setCodec(jp.getCodec());
            builder.setPreviousUid((Uid)ATTR_DESERIALIZER.deserialize(parser, ctx));
        }
        if (tree.has("token")) {
            parser = tree.get("token").traverse();
            parser.setCodec(jp.getCodec());
            builder.setToken(SYNC_TOKEN_DESERIALIZER.deserialize(parser, ctx));
        }
        if (tree.has("deltaType")) {
            builder.setDeltaType(SyncDeltaType.valueOf((String)tree.get("deltaType").asText()));
        }
        if (tree.has("object")) {
            parser = tree.get("object").traverse();
            parser.setCodec(jp.getCodec());
            builder.setObject(CONNECTOR_OBJECT_DESERIALIZER.deserialize(parser, ctx));
        }
        return builder.build();
    }
}

