/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.saml.idp.metadata;

import com.github.benmanes.caffeine.cache.Cache;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.SAML2IdPEntityTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.service.SAML2IdPEntityService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.support.saml.idp.metadata.locator.AbstractSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class WASamlIdPMetadataLocator
extends AbstractSamlIdPMetadataLocator {
    protected static final Logger LOG = LoggerFactory.getLogger(WASamlIdPMetadataLocator.class);
    protected final WARestClient waRestClient;

    public WASamlIdPMetadataLocator(CipherExecutor<String, String> metadataCipherExecutor, Cache<String, SamlIdPMetadataDocument> metadataCache, ApplicationContext applicationContext, WARestClient waRestClient) {
        super(metadataCipherExecutor, metadataCache, applicationContext);
        this.waRestClient = waRestClient;
    }

    public String getAppliesToFor(Optional<SamlRegisteredService> registeredService) {
        return registeredService.map(SamlRegisteredService::getIdpMetadataLocation).flatMap(Optional::ofNullable).orElse("Syncope");
    }

    protected SAML2IdPEntityTO fetchFromCore(Optional<SamlRegisteredService> registeredService) {
        SAML2IdPEntityService idpEntityService = (SAML2IdPEntityService)this.waRestClient.getService(SAML2IdPEntityService.class);
        SAML2IdPEntityTO result = null;
        try {
            result = idpEntityService.get(this.getAppliesToFor(registeredService));
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound && registeredService.isPresent()) {
                String idp = registeredService.get().getIdpMetadataLocation();
                if (idp == null || "Syncope".equals(idp)) {
                    result = idpEntityService.get("Syncope");
                }
            }
            throw e;
        }
        return result;
    }

    protected SamlIdPMetadataDocument fetchInternal(Optional<SamlRegisteredService> registeredService) {
        try {
            LOG.info("Locating SAML2 IdP metadata document");
            SAML2IdPEntityTO entityTO = this.fetchFromCore(registeredService);
            if (entityTO != null) {
                SamlIdPMetadataDocument document = new SamlIdPMetadataDocument();
                document.setAppliesTo(entityTO.getKey());
                document.setMetadata(new String(Base64.getDecoder().decode(entityTO.getMetadata()), StandardCharsets.UTF_8));
                if (entityTO.getSigningCertificate() != null) {
                    document.setSigningCertificate(new String(Base64.getDecoder().decode(entityTO.getSigningCertificate()), StandardCharsets.UTF_8));
                }
                if (entityTO.getSigningKey() != null) {
                    document.setSigningKey(new String(Base64.getDecoder().decode(entityTO.getSigningKey().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                }
                if (entityTO.getEncryptionCertificate() != null) {
                    document.setEncryptionCertificate(new String(Base64.getDecoder().decode(entityTO.getEncryptionCertificate()), StandardCharsets.UTF_8));
                }
                if (entityTO.getEncryptionKey() != null) {
                    document.setEncryptionKey(new String(Base64.getDecoder().decode(entityTO.getEncryptionKey().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                }
                if (document.isValid()) {
                    LOG.debug("Found SAML2 IdP metadata document: {}", (Object)document.getId());
                    return document;
                }
            }
            LOG.warn("Not a valid SAML2 IdP metadata document");
            return null;
        }
        catch (Exception e) {
            SyncopeClientException sce;
            if (e instanceof SyncopeClientException && (sce = (SyncopeClientException)((Object)e)).getType() == ClientExceptionType.NotFound) {
                LOG.info(e.getMessage());
            } else if (LOG.isDebugEnabled()) {
                LOG.error("While fetching SAML2 IdP metadata", (Throwable)e);
            } else {
                LOG.error("While fetching SAML2 IdP metadata: {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    public SamlIdPMetadataDocument fetch(Optional<SamlRegisteredService> registeredService) {
        String key = this.getAppliesToFor(registeredService);
        return (SamlIdPMetadataDocument)this.getMetadataCache().get((Object)key, __ -> {
            SamlIdPMetadataDocument metadataDocument = this.fetchInternal(registeredService);
            if (metadataDocument != null && metadataDocument.isValid()) {
                LOG.trace("Fetched and cached SAML IdP metadata document [{}] under key [{}]", (Object)metadataDocument, (Object)key);
                return metadataDocument;
            }
            LOG.trace("SAML IdP metadata document [{}] is considered invalid", (Object)metadataDocument);
            return null;
        });
    }

    public boolean shouldGenerateMetadataFor(Optional<SamlRegisteredService> registeredService) {
        return registeredService.isEmpty() || this.fetchFromCore(registeredService) == null;
    }
}

