/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.wicketstuff.egrid.column.EditableActionsColumn;
import org.wicketstuff.egrid.component.EditableDataTable;
import org.wicketstuff.egrid.provider.IEditableDataProvider;
import org.wicketstuff.egrid.toolbar.AddRowToolbar;
import org.wicketstuff.egrid.toolbar.HeadersToolbar;
import org.wicketstuff.egrid.toolbar.NavigationToolbar;
import org.wicketstuff.egrid.toolbar.NoRecordsToolbar;

public class EditableGrid<T extends Serializable, S>
extends Panel {
    private static final long serialVersionUID = 1L;
    private final EditableDataTable<T, S> dataTable;
    private final IEditableDataProvider<T, S> dataProvider;

    public EditableGrid(String id, List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage, Class<T> clazz) {
        super(id);
        this.dataProvider = dataProvider;
        ArrayList<IColumn<T, S>> newCols = new ArrayList<IColumn<T, S>>(columns);
        newCols.add((IColumn<T, S>)this.newActionsColumn((IModel<String>)new StringResourceModel("editableGrid.actionsColumn.headerText")));
        Form<T> form = this.createForm("form");
        this.dataTable = this.newDataTable("dataTable", newCols, dataProvider, rowsPerPage, clazz);
        form.add(new Component[]{this.dataTable});
        this.add(new Component[]{form});
    }

    protected EditableActionsColumn<T, S> newActionsColumn(IModel<String> stringModel) {
        return new EditableActionsColumn<T, S>(stringModel){
            private static final long serialVersionUID = 1L;

            @Override
            public void onEdit(AjaxRequestTarget target, IModel<T> rowModel) {
                super.onEdit(target, rowModel);
                EditableGrid.this.onEdit(target, rowModel);
            }

            @Override
            protected void onCancel(AjaxRequestTarget target, IModel<T> rowModel) {
                super.onCancel(target, rowModel);
                EditableGrid.this.onCancel(target, rowModel);
            }

            @Override
            protected void onSave(AjaxRequestTarget target, IModel<T> rowModel) {
                super.onSave(target, rowModel);
                EditableGrid.this.onSave(target, rowModel);
            }

            @Override
            protected void onError(AjaxRequestTarget target, IModel<T> rowModel) {
                super.onError(target, rowModel);
                EditableGrid.this.onError(target, rowModel);
            }

            @Override
            protected void onDelete(AjaxRequestTarget target, IModel<T> rowModel) {
                super.onDelete(target, rowModel);
                EditableGrid.this.onDelete(target, rowModel);
            }

            @Override
            protected boolean allowEdit(Item<T> rowItem) {
                return EditableGrid.this.allowEdit(rowItem);
            }

            @Override
            protected boolean allowDelete(Item<T> rowItem) {
                return EditableGrid.this.allowDelete(rowItem);
            }
        };
    }

    protected Form<T> createForm(String id) {
        return new NonValidatingForm(id);
    }

    protected EditableDataTable<T, S> newDataTable(String id, List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage, Class<T> clazz) {
        EditableDataTable dataTable = new EditableDataTable<T, S>(id, columns, dataProvider, rowsPerPage){
            private static final long serialVersionUID = 1L;

            @Override
            protected Item<T> newRowItem(String id, int index, IModel<T> model) {
                return EditableGrid.this.newRowItem(id, index, model);
            }
        };
        dataTable.addTopToolbar(new NavigationToolbar(dataTable));
        dataTable.addTopToolbar(new HeadersToolbar(dataTable, dataProvider));
        dataTable.addBottomToolbar(new NoRecordsToolbar(dataTable));
        if (this.allowAdd()) {
            dataTable.addBottomToolbar(this.newAddRowToolbar(dataTable, clazz));
        }
        return dataTable;
    }

    protected Item<T> newRowItem(String id, int index, IModel<T> model) {
        return new EditableDataTable.RowItem<T>(id, index, model, this.dataTable.getMarkupId());
    }

    protected AddRowToolbar<T> newAddRowToolbar(EditableDataTable<T, S> dataTable, Class<T> clazz) {
        return new AddRowToolbar<T>(dataTable, clazz){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onAdd(AjaxRequestTarget target, IModel<T> rowModel) {
                EditableGrid.this.onAdd(target, rowModel);
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                EditableGrid.this.onError(target, null);
            }
        };
    }

    protected void onAdd(AjaxRequestTarget target, IModel<T> rowModel) {
        this.dataProvider.add((Serializable)rowModel.getObject());
        target.add(new Component[]{this.dataTable});
    }

    protected void onEdit(AjaxRequestTarget target, IModel<T> rowModel) {
        target.add(new Component[]{this.dataTable.getTopToolbars()});
    }

    protected void onCancel(AjaxRequestTarget target, IModel<T> rowModel) {
        if (!this.dataTable.isCurrentlyAnyEdit()) {
            target.add(new Component[]{this.dataTable});
        }
    }

    protected void onSave(AjaxRequestTarget target, IModel<T> rowModel) {
        this.dataProvider.update((Serializable)rowModel.getObject());
        if (!this.dataTable.isCurrentlyAnyEdit()) {
            target.add(new Component[]{this.dataTable});
        }
    }

    protected void onError(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected void onDelete(AjaxRequestTarget target, IModel<T> rowModel) {
        this.dataProvider.remove((Serializable)rowModel.getObject());
        target.add(new Component[]{this.dataTable});
    }

    protected boolean allowAdd() {
        return true;
    }

    protected boolean allowEdit(Item<T> rowItem) {
        return true;
    }

    protected boolean allowDelete(Item<T> rowItem) {
        return true;
    }

    public EditableDataTable<T, S> getDataTable() {
        return this.dataTable;
    }

    public IEditableDataProvider<T, S> getDataProvider() {
        return this.dataProvider;
    }

    private class NonValidatingForm
    extends Form<T> {
        private static final long serialVersionUID = 1L;

        public NonValidatingForm(String id) {
            super(id);
            this.setOutputMarkupId(true);
        }

        public void process(IFormSubmitter submittingComponent) {
            this.delegateSubmit(submittingComponent);
        }
    }
}

