/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.FileFormatProperties;
import org.apache.sysml.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.io.MatrixReaderFactory;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataNumItemsByEachReducer;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.sort.ReadWithZeros;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.OrderedJSONObject;

public class MapReduceTool {
    private static final int MAX_DELETE_RETRIES = 10;
    private static final Log LOG = LogFactory.getLog((String)MapReduceTool.class.getName());

    public static String getUniqueKeyPerTask(JobConf job, boolean inMapper) {
        String nodePrefix = job.get(MRConfigurationNames.MR_TASK_ATTEMPT_ID);
        int i = inMapper ? nodePrefix.indexOf("_m_") : nodePrefix.indexOf("_r_");
        int j = nodePrefix.lastIndexOf("_");
        nodePrefix = nodePrefix.substring(i + 3, j);
        return String.valueOf(Long.parseLong(nodePrefix));
    }

    public static int getUniqueTaskId(JobConf job) {
        String nodePrefix = job.get(MRConfigurationNames.MR_TASK_ATTEMPT_ID);
        int j = nodePrefix.lastIndexOf("_");
        int i = nodePrefix.lastIndexOf("_", j - 1);
        nodePrefix = nodePrefix.substring(i + 1, j);
        return Integer.valueOf(nodePrefix);
    }

    public static String getGloballyUniqueName(JobConf job) {
        return job.get(MRConfigurationNames.MR_TASK_ATTEMPT_ID);
    }

    public static boolean existsFileOnHDFS(String fname) {
        if (fname == null || fname.isEmpty() || fname.trim().isEmpty()) {
            return false;
        }
        try {
            Path path = new Path(fname);
            return IOUtilFunctions.getFileSystem(path).exists(path);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed check existsFileOnHDFS.", (Throwable)ex);
            return false;
        }
    }

    public static boolean isDirectory(String fname) {
        if (fname == null || fname.isEmpty() || fname.trim().isEmpty()) {
            return false;
        }
        try {
            Path path = new Path(fname);
            return IOUtilFunctions.getFileSystem(path).isDirectory(path);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed check isDirectory.", (Throwable)ex);
            return false;
        }
    }

    public static FileStatus[] getDirectoryListing(String fname) {
        try {
            Path path = new Path(fname);
            return IOUtilFunctions.getFileSystem(path).listStatus(path);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed listing of directory contents.", (Throwable)ex);
            return new FileStatus[0];
        }
    }

    public static void deleteFileWithMTDIfExistOnHDFS(String fname) throws IOException {
        MapReduceTool.deleteFileIfExistOnHDFS(fname);
        MapReduceTool.deleteFileIfExistOnHDFS(fname + ".mtd");
    }

    public static void deleteFileIfExistOnHDFS(String dir) throws IOException {
        Path path = new Path(dir);
        MapReduceTool.deleteFileIfExists(IOUtilFunctions.getFileSystem(path), path);
    }

    public static void deleteFileIfExistOnHDFS(Path outpath, JobConf job) throws IOException {
        MapReduceTool.deleteFileIfExists(IOUtilFunctions.getFileSystem(outpath, (Configuration)job), outpath);
    }

    public static void deleteFileIfExistOnLFS(Path outpath, JobConf job) throws IOException {
        MapReduceTool.deleteFileIfExists((FileSystem)FileSystem.getLocal((Configuration)job), outpath);
    }

    private static void deleteFileIfExists(FileSystem fs, Path outpath) throws IOException {
        if (fs.exists(outpath)) {
            for (int retries = 10; !fs.delete(outpath, true) && retries > 0; --retries) {
            }
        }
    }

    public static boolean isHDFSFileEmpty(String dir) throws IOException {
        if (dir == null || dir.isEmpty() || dir.trim().isEmpty()) {
            return false;
        }
        Path path = new Path(dir);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        return MapReduceTool.isFileEmpty(fs, path);
    }

    public static boolean isFileEmpty(FileSystem fs, Path dir) throws IOException {
        FileStatus fstat = fs.getFileStatus(dir);
        if (fstat.isDirectory() || IOUtilFunctions.isObjectStoreFileScheme(dir)) {
            FileStatus[] stats = fs.listStatus(dir);
            if (stats != null) {
                for (FileStatus stat : stats) {
                    if (stat.getLen() <= 0L) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return fstat.getLen() == 0L;
    }

    public static void renameFileOnHDFS(String originalDir, String newDir) throws IOException {
        Path pathOrig = new Path(originalDir);
        Path pathNew = new Path(newDir);
        if (!IOUtilFunctions.isSameFileScheme(pathOrig, pathNew)) {
            throw new IOException("Cannot rename files to different target file system.");
        }
        MapReduceTool.deleteFileIfExistOnHDFS(newDir);
        FileSystem fs = IOUtilFunctions.getFileSystem(pathOrig);
        if (!fs.exists(pathOrig)) {
            throw new FileNotFoundException(originalDir);
        }
        fs.rename(pathOrig, pathNew);
    }

    public static void mergeIntoSingleFile(String originalDir, String newFile) throws IOException {
        Path pathOrig = new Path(originalDir);
        Path pathNew = new Path(newFile);
        if (!IOUtilFunctions.isSameFileScheme(pathOrig, pathNew)) {
            throw new IOException("Cannot merge files into different target file system.");
        }
        FileSystem fs = IOUtilFunctions.getFileSystem(pathOrig);
        FileUtil.copyMerge((FileSystem)fs, (Path)pathOrig, (FileSystem)fs, (Path)pathNew, (boolean)true, (Configuration)ConfigurationManager.getCachedJobConf(), null);
    }

    public static void copyFileOnHDFS(String originalDir, String newDir) throws IOException {
        Path originalPath = new Path(originalDir);
        Path newPath = new Path(newDir);
        boolean deleteSource = false;
        boolean overwrite = true;
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        FileSystem fs = IOUtilFunctions.getFileSystem(originalPath, (Configuration)job);
        if (fs.exists(originalPath)) {
            FileUtil.copy((FileSystem)fs, (Path)originalPath, (FileSystem)fs, (Path)newPath, (boolean)deleteSource, (boolean)overwrite, (Configuration)job);
        }
    }

    public static long estimateNnzBasedOnFileSize(Path path, long rlen, long clen, int brlen, int bclen, double factor) throws IOException {
        return (long)Math.min((double)(rlen * clen), (double)(rlen * clen) * ((double)MapReduceTool.getFilesizeOnHDFS(path) / factor / (double)OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, (long)brlen, (long)bclen, 1.0)));
    }

    public static long getFilesizeOnHDFS(Path path) throws IOException {
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        long ret = 0L;
        ret = fs.isDirectory(path) ? fs.getContentSummary(path).getLength() : fs.getFileStatus(path).getLen();
        return ret;
    }

    private static BufferedReader setupInputFile(String filename) throws IOException {
        Path path = new Path(filename);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
        return br;
    }

    public static double readDoubleFromHDFSFile(String filename) throws IOException {
        return (Double)MapReduceTool.readObjectFromHDFSFile(filename, Expression.ValueType.DOUBLE);
    }

    public static long readIntegerFromHDFSFile(String filename) throws IOException {
        return (Long)MapReduceTool.readObjectFromHDFSFile(filename, Expression.ValueType.INT);
    }

    public static boolean readBooleanFromHDFSFile(String filename) throws IOException {
        return (Boolean)MapReduceTool.readObjectFromHDFSFile(filename, Expression.ValueType.BOOLEAN);
    }

    public static String readStringFromHDFSFile(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = MapReduceTool.setupInputFile(filename);){
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static Object readObjectFromHDFSFile(String filename, Expression.ValueType vt) throws IOException {
        String line = null;
        try (BufferedReader br = MapReduceTool.setupInputFile(filename);){
            line = br.readLine();
        }
        if (line == null) {
            throw new IOException("Empty file on hdfs: " + filename);
        }
        switch (vt) {
            case BOOLEAN: {
                return Boolean.parseBoolean(line);
            }
            case DOUBLE: {
                return Double.parseDouble(line);
            }
            case INT: {
                return Long.parseLong(line);
            }
        }
        return line;
    }

    private static BufferedWriter setupOutputFile(String filename) throws IOException {
        Path path = new Path(filename);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
        return br;
    }

    public static void writeDoubleToHDFS(double d, String filename) throws IOException {
        MapReduceTool.writeObjectToHDFS(d, filename);
    }

    public static void writeIntToHDFS(long i, String filename) throws IOException {
        MapReduceTool.writeObjectToHDFS(i, filename);
    }

    public static void writeBooleanToHDFS(boolean b, String filename) throws IOException {
        MapReduceTool.writeObjectToHDFS(b, filename);
    }

    public static void writeStringToHDFS(String s, String filename) throws IOException {
        MapReduceTool.writeObjectToHDFS(s, filename);
    }

    public static void writeObjectToHDFS(Object obj, String filename) throws IOException {
        try (BufferedWriter br = MapReduceTool.setupOutputFile(filename);){
            br.write(obj.toString());
        }
    }

    public static void writeDimsFile(String filename, byte[] unknownFlags, long[] maxRows, long[] maxCols) throws IOException {
        try (BufferedWriter br = MapReduceTool.setupOutputFile(filename);){
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < unknownFlags.length; ++i) {
                if (unknownFlags[i] == 0) continue;
                line.append(i);
                line.append(" " + maxRows[i]);
                line.append(" " + maxCols[i]);
                line.append("\n");
            }
            br.write(line.toString());
        }
    }

    public static MatrixCharacteristics[] processDimsFiles(String dir, MatrixCharacteristics[] stats) throws IOException {
        Path path = new Path(dir);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        if (!fs.exists(path)) {
            return stats;
        }
        FileStatus fstat = fs.getFileStatus(path);
        if (fstat.isDirectory()) {
            FileStatus[] files = fs.listStatus(path);
            for (int i = 0; i < files.length; ++i) {
                Path filePath = files[i].getPath();
                try (BufferedReader br = MapReduceTool.setupInputFile(filePath.toString());){
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        String[] parts = line.split(" ");
                        int resultIndex = Integer.parseInt(parts[0]);
                        long maxRows = Long.parseLong(parts[1]);
                        long maxCols = Long.parseLong(parts[2]);
                        stats[resultIndex].setDimension(stats[resultIndex].getRows() < maxRows ? maxRows : stats[resultIndex].getRows(), stats[resultIndex].getCols() < maxCols ? maxCols : stats[resultIndex].getCols());
                    }
                    continue;
                }
            }
        } else {
            throw new IOException(dir + " is expected to be a folder!");
        }
        return stats;
    }

    public static void writeMetaDataFile(String mtdfile, Expression.ValueType vt, MatrixCharacteristics mc, OutputInfo outinfo) throws IOException {
        MapReduceTool.writeMetaDataFile(mtdfile, vt, null, Expression.DataType.MATRIX, mc, outinfo);
    }

    public static void writeMetaDataFile(String mtdfile, Expression.ValueType vt, Expression.ValueType[] schema, Expression.DataType dt, MatrixCharacteristics mc, OutputInfo outinfo) throws IOException {
        MapReduceTool.writeMetaDataFile(mtdfile, vt, schema, dt, mc, outinfo, null);
    }

    public static void writeMetaDataFile(String mtdfile, Expression.ValueType vt, MatrixCharacteristics mc, OutputInfo outinfo, FileFormatProperties formatProperties) throws IOException {
        MapReduceTool.writeMetaDataFile(mtdfile, vt, null, Expression.DataType.MATRIX, mc, outinfo, formatProperties);
    }

    public static void writeMetaDataFile(String mtdfile, Expression.ValueType vt, Expression.ValueType[] schema, Expression.DataType dt, MatrixCharacteristics mc, OutputInfo outinfo, FileFormatProperties formatProperties) throws IOException {
        Path path = new Path(mtdfile);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));){
            String mtd = MapReduceTool.metaDataToString(vt, schema, dt, mc, outinfo, formatProperties);
            br.write(mtd);
        }
        catch (Exception e) {
            throw new IOException("Error creating and writing metadata JSON file", e);
        }
    }

    public static void writeScalarMetaDataFile(String mtdfile, Expression.ValueType vt) throws IOException {
        Path path = new Path(mtdfile);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));){
            String mtd = MapReduceTool.metaDataToString(vt, null, Expression.DataType.SCALAR, null, OutputInfo.TextCellOutputInfo, null);
            br.write(mtd);
        }
        catch (Exception e) {
            throw new IOException("Error creating and writing metadata JSON file", e);
        }
    }

    public static String metaDataToString(Expression.ValueType vt, Expression.ValueType[] schema, Expression.DataType dt, MatrixCharacteristics mc, OutputInfo outinfo, FileFormatProperties formatProperties) throws JSONException, DMLRuntimeException {
        String userName;
        String description;
        OrderedJSONObject mtd = new OrderedJSONObject();
        mtd.put("data_type", (Object)dt.toString().toLowerCase());
        if (schema == null) {
            mtd.put("value_type", (Object)vt.toString().toLowerCase());
        } else {
            StringBuffer schemaSB = new StringBuffer();
            for (int i = 0; i < schema.length; ++i) {
                if (schema[i] == Expression.ValueType.UNKNOWN) {
                    schemaSB.append("*");
                } else {
                    schemaSB.append(schema[i].toString());
                }
                schemaSB.append(",");
            }
            mtd.put("schema", (Object)schemaSB.toString());
        }
        if (!dt.isScalar()) {
            mtd.put("rows", mc.getRows());
            mtd.put("cols", mc.getCols());
            if (dt.isMatrix()) {
                if (outinfo == OutputInfo.BinaryBlockOutputInfo) {
                    mtd.put("rows_in_block", mc.getRowsPerBlock());
                    mtd.put("cols_in_block", mc.getColsPerBlock());
                }
                mtd.put("nnz", mc.getNonZeros());
            }
        }
        mtd.put("format", (Object)OutputInfo.outputInfoToStringExternal(outinfo));
        if (outinfo == OutputInfo.CSVOutputInfo) {
            FileFormatPropertiesCSV csvProperties = formatProperties == null ? new FileFormatPropertiesCSV() : (FileFormatPropertiesCSV)formatProperties;
            mtd.put("header", csvProperties.hasHeader());
            mtd.put("sep", (Object)csvProperties.getDelim());
        }
        if (formatProperties != null && StringUtils.isNotEmpty((String)(description = formatProperties.getDescription()))) {
            String jsonDescription = StringEscapeUtils.escapeJson((String)description);
            mtd.put("description", (Object)jsonDescription);
        }
        if (StringUtils.isNotEmpty((String)(userName = System.getProperty("user.name")))) {
            mtd.put("author", (Object)userName);
        } else {
            mtd.put("author", (Object)"SystemML");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        mtd.put("created", (Object)sdf.format(new Date()));
        return mtd.toString(4);
    }

    public static double[][] readMatrixFromHDFS(String dir, InputInfo inputinfo, long rlen, long clen, int brlen, int bclen) throws IOException, DMLRuntimeException {
        MatrixReader reader = MatrixReaderFactory.createMatrixReader(inputinfo);
        long estnnz = rlen <= 0L || clen <= 0L ? -1L : rlen * clen;
        MatrixBlock mb = reader.readMatrixFromHDFS(dir, rlen, clen, brlen, bclen, estnnz);
        return DataConverter.convertToDoubleMatrix(mb);
    }

    public static double[] readColumnVectorFromHDFS(String dir, InputInfo inputinfo, long rlen, long clen, int brlen, int bclen) throws IOException, DMLRuntimeException {
        MatrixReader reader = MatrixReaderFactory.createMatrixReader(inputinfo);
        long estnnz = rlen <= 0L || clen <= 0L ? -1L : rlen * clen;
        MatrixBlock mb = reader.readMatrixFromHDFS(dir, rlen, clen, brlen, bclen, estnnz);
        return DataConverter.convertToDoubleVector(mb, false);
    }

    public static double median(String dir, MetaDataNumItemsByEachReducer metadata) throws IOException {
        long[] counts = metadata.getNumItemsArray();
        long[] ranges = new long[counts.length];
        ranges[0] = counts[0];
        for (int i = 1; i < counts.length; ++i) {
            ranges[i] = ranges[i - 1] + counts[i];
        }
        long total = ranges[ranges.length - 1];
        return MapReduceTool.pickValueWeight(dir, metadata, 0.5, total % 2L == 0L)[0];
    }

    public static double pickValue(String dir, MetaDataNumItemsByEachReducer metadata, double p) throws IOException {
        return MapReduceTool.pickValueWeight(dir, metadata, p, false)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] pickValueWeight(String dir, MetaDataNumItemsByEachReducer metadata, double p, boolean average) throws IOException {
        long[] counts = metadata.getNumItemsArray();
        long[] ranges = new long[counts.length];
        ranges[0] = counts[0];
        for (int i = 1; i < counts.length; ++i) {
            ranges[i] = ranges[i - 1] + counts[i];
        }
        long total = ranges[ranges.length - 1];
        average = average && total % 2L == 0L;
        int currentPart = 0;
        double cum_weight = 0.0;
        long pos = (long)Math.ceil((double)total * p);
        while (ranges[currentPart] < pos) {
            cum_weight += (double)ranges[++currentPart];
        }
        int offset = currentPart > 0 ? (int)(pos - ranges[currentPart - 1] - 1L) : (int)pos - 1;
        Path path = new Path(dir);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        FileStatus[] files = fs.listStatus(path);
        Path fileToRead = null;
        for (FileStatus file : files) {
            if (!file.getPath().toString().endsWith(Integer.toString(currentPart))) continue;
            fileToRead = file.getPath();
            break;
        }
        if (fileToRead == null) {
            throw new RuntimeException("cannot read partition " + currentPart);
        }
        int buffsz = 65536;
        DoubleWritable readKey = new DoubleWritable();
        IntWritable readValue = new IntWritable();
        FSDataInputStream currentStream = null;
        double ret = -1.0;
        try {
            currentStream = fs.open(fileToRead, buffsz);
            boolean contain0s = false;
            long numZeros = 0L;
            if (currentPart == metadata.getPartitionOfZero()) {
                contain0s = true;
                numZeros = metadata.getNumberOfZero();
            }
            ReadWithZeros reader = new ReadWithZeros(currentStream, contain0s, numZeros);
            int numRead = 0;
            while (numRead <= offset) {
                reader.readNextKeyValuePairs(readKey, readValue);
                numRead += readValue.get();
                cum_weight += (double)readValue.get();
            }
            ret = readKey.get();
            if (average && numRead <= offset + 1) {
                reader.readNextKeyValuePairs(readKey, readValue);
                cum_weight += (double)readValue.get();
                ret = (ret + readKey.get()) / 2.0;
            }
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(currentStream);
            throw throwable;
        }
        IOUtilFunctions.closeSilently((Closeable)currentStream);
        return new double[]{ret, average ? -1 : readValue.get(), average ? -1.0 : cum_weight};
    }

    public static void createDirIfNotExistOnHDFS(String dir, String permissions) throws IOException {
        MapReduceTool.createDirIfNotExistOnHDFS(new Path(dir), permissions);
    }

    public static void createDirIfNotExistOnHDFS(Path path, String permissions) throws IOException {
        try {
            FileSystem fs = IOUtilFunctions.getFileSystem(path);
            if (!fs.exists(path)) {
                char[] c = permissions.toCharArray();
                short sU = (short)((c[0] - 48) * 64);
                short sG = (short)((c[1] - 48) * 8);
                short sO = (short)(c[2] - 48);
                short mode = (short)(sU + sG + sO);
                FsPermission perm = new FsPermission(mode);
                fs.mkdirs(path, perm);
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed in creating a non existing dir on HDFS", ex);
        }
    }

    public static FSDataOutputStream getHDFSDataOutputStream(String filename, boolean overwrite) throws IOException {
        Path path = new Path(filename);
        return IOUtilFunctions.getFileSystem(path).create(path, overwrite);
    }
}

