/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.matrix.CSVReblockMR;

public class CSVAssignRowIDReducer
extends MapReduceBase
implements Reducer<ByteWritable, CSVReblockMR.OffsetCount, ByteWritable, CSVReblockMR.OffsetCount> {
    private ArrayList<CSVReblockMR.OffsetCount> list = new ArrayList();

    public void reduce(ByteWritable key, Iterator<CSVReblockMR.OffsetCount> values, OutputCollector<ByteWritable, CSVReblockMR.OffsetCount> out, Reporter report) throws IOException {
        while (values.hasNext()) {
            this.list.add(new CSVReblockMR.OffsetCount(values.next()));
        }
        Collections.sort(this.list);
        long lineOffset = 0L;
        for (CSVReblockMR.OffsetCount oc : this.list) {
            long count = oc.count;
            oc.count = lineOffset;
            out.collect((Object)key, (Object)oc);
            lineOffset += count;
        }
        report.incrCounter("num.rows.in.matrix.", key.toString(), lineOffset);
        this.list.clear();
    }
}

