/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixIndexes;
import org.apache.sysml.runtime.matrix.data.WeightedCell;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class GroupedAggMRCombiner
extends ReduceBase
implements Reducer<TaggedMatrixIndexes, WeightedCell, TaggedMatrixIndexes, WeightedCell> {
    private HashMap<Byte, GroupedAggregateInstruction> grpaggInstructions = new HashMap();
    private CM_COV_Object cmObj = new CM_COV_Object();
    private HashMap<Byte, CM> cmFn = new HashMap();
    private WeightedCell outCell = new WeightedCell();

    public void reduce(TaggedMatrixIndexes key, Iterator<WeightedCell> values, OutputCollector<TaggedMatrixIndexes, WeightedCell> out, Reporter reporter) throws IOException {
        boolean isPartialAgg;
        long start;
        block13: {
            start = System.currentTimeMillis();
            GroupedAggregateInstruction ins = this.grpaggInstructions.get(key.getTag());
            Operator op = ins.getOperator();
            isPartialAgg = true;
            try {
                if (op instanceof CMOperator) {
                    if (((CMOperator)op).isPartialAggregateOperator()) {
                        this.cmObj.reset();
                        CM lcmFn = this.cmFn.get(key.getTag());
                        while (values.hasNext()) {
                            WeightedCell value = values.next();
                            lcmFn.execute(this.cmObj, value.getValue(), value.getWeight());
                        }
                        this.outCell.setValue(this.cmObj.getRequiredPartialResult(op));
                        this.outCell.setWeight(this.cmObj.getWeight());
                    } else {
                        isPartialAgg = false;
                        while (values.hasNext()) {
                            out.collect((Object)key, (Object)values.next());
                        }
                    }
                    break block13;
                }
                if (op instanceof AggregateOperator) {
                    AggregateOperator aggop = (AggregateOperator)op;
                    if (aggop.correctionExists) {
                        KahanObject buffer = new KahanObject(aggop.initialValue, 0.0);
                        KahanPlus.getKahanPlusFnObject();
                        while (values.hasNext()) {
                            WeightedCell value = values.next();
                            aggop.increOp.fn.execute((Data)buffer, value.getValue() * value.getWeight());
                        }
                        this.outCell.setValue(buffer._sum);
                        this.outCell.setWeight(1.0);
                    } else {
                        double v = aggop.initialValue;
                        while (values.hasNext()) {
                            WeightedCell value = values.next();
                            v = aggop.increOp.fn.execute(v, value.getValue() * value.getWeight());
                        }
                        this.outCell.setValue(v);
                        this.outCell.setWeight(1.0);
                    }
                    break block13;
                }
                throw new IOException("Unsupported operator in instruction: " + ins);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        if (isPartialAgg) {
            out.collect((Object)key, (Object)this.outCell);
        }
        reporter.incrCounter(ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
    }

    @Override
    public void configure(JobConf job) {
        try {
            GroupedAggregateInstruction[] grpaggIns = MRJobConfiguration.getGroupedAggregateInstructions(job);
            if (grpaggIns != null) {
                for (GroupedAggregateInstruction ins : grpaggIns) {
                    this.grpaggInstructions.put(ins.output, ins);
                    if (!(ins.getOperator() instanceof CMOperator)) continue;
                    this.cmFn.put(ins.output, CM.getCMFnObject(((CMOperator)ins.getOperator()).getAggOpType()));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

