/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.codegen;

import java.util.ArrayList;
import jcuda.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.codegen.SpoofCUDAOperator;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.codegen.SpoofRowwise;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;

public class SpoofCUDARowwise
extends SpoofRowwise
implements SpoofCUDAOperator {
    private static final long serialVersionUID = 3080001135814944399L;
    private static final Log LOG = LogFactory.getLog((String)SpoofCUDARowwise.class.getName());
    private final int ID;
    private final SpoofCUDAOperator.PrecisionProxy call;
    private Pointer ptr;

    public SpoofCUDARowwise(SpoofRowwise.RowType type, long constDim2, boolean tB1, int reqVectMem, int id, SpoofCUDAOperator.PrecisionProxy ep) {
        super(type, constDim2, tB1, reqVectMem);
        this.ID = id;
        this.call = ep;
        this.ptr = null;
    }

    @Override
    public String getName() {
        return this.getSpoofType();
    }

    @Override
    public void setScalarPtr(Pointer _ptr) {
        this.ptr = _ptr;
    }

    @Override
    public Pointer getScalarPtr() {
        return this.ptr;
    }

    @Override
    public void releaseScalarGPUMemory(ExecutionContext ec) {
        if (this.ptr != null) {
            ec.getGPUContext(0).cudaFreeHelper(this.getSpoofType(), this.ptr, DMLScript.EAGER_CUDA_FREE);
            this.ptr = null;
        }
    }

    @Override
    public ScalarObject execute(ExecutionContext ec, ArrayList<MatrixObject> inputs, ArrayList<ScalarObject> scalarObjects) {
        double[] result = new double[1];
        Pointer ptr = ec.getGPUContext(0).allocate(this.getName(), LibMatrixCUDA.sizeOfDataType);
        long[] out = new long[]{1L, 1L, 1L, 0L, 0L, GPUObject.getPointerAddress(ptr)};
        int offset = 1;
        if (this.call.exec(ec, this, this.ID, this.prepareInputPointers(ec, inputs, offset), this.prepareSideInputPointers(ec, inputs, offset, this._tB1), out, scalarObjects, 0L) != 0) {
            LOG.error((Object)("SpoofCUDA " + this.getSpoofType() + " operator failed to execute. Trying Java fallback.\n"));
        }
        LibMatrixCUDA.cudaSupportFunctions.deviceToHost(ec.getGPUContext(0), ptr, result, this.getName(), false);
        return new DoubleObject(result[0]);
    }

    @Override
    public MatrixObject execute(ExecutionContext ec, ArrayList<MatrixObject> inputs, ArrayList<ScalarObject> scalarObjects, String outputName) {
        int m = (int)inputs.get(0).getNumRows();
        int n = (int)inputs.get(0).getNumColumns();
        int n2 = this._type.isConstDim2(this._constDim2) ? (int)this._constDim2 : (this._type.isRowTypeB1() || SpoofCUDARowwise.hasMatrixObjectSideInput(inputs) ? SpoofCUDARowwise.getMinColsMatrixObjectSideInputs(inputs) : -1);
        SpoofRowwise.OutputDimensions out_dims = new SpoofRowwise.OutputDimensions(m, n, n2);
        ec.setMetaData(outputName, out_dims.rows, out_dims.cols);
        MatrixObject out_obj = ec.getDenseMatrixOutputForGPUInstruction(outputName, out_dims.rows, out_dims.cols).getKey();
        int offset = 1;
        if (this.call.exec(ec, this, this.ID, this.prepareInputPointers(ec, inputs, offset), this.prepareSideInputPointers(ec, inputs, offset, this._tB1), this.prepareOutputPointers(ec, out_obj, false), scalarObjects, 0L) != 0) {
            LOG.error((Object)("SpoofCUDA " + this.getSpoofType() + " operator failed to execute. Trying Java fallback.\n"));
        }
        return out_obj;
    }

    @Override
    protected void genexec(double[] a, int ai, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int ci, int len, long grix, int rix) {
    }

    @Override
    protected void genexec(double[] avals, int[] aix, int ai, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int ci, int alen, int n, long grix, int rix) {
    }

    @Override
    public int execute_sp(long ctx, long[] meta, long[] in, long[] sides, long[] out, long scalars) {
        return SpoofCUDARowwise.execute_f(ctx, meta, in, sides, out, scalars);
    }

    @Override
    public int execute_dp(long ctx, long[] meta, long[] in, long[] sides, long[] out, long scalars) {
        return SpoofCUDARowwise.execute_d(ctx, meta, in, sides, out, scalars);
    }

    public static native int execute_f(long var0, long[] var2, long[] var3, long[] var4, long[] var5, long var6);

    public static native int execute_d(long var0, long[] var2, long[] var3, long[] var4, long[] var5, long var6);
}

