/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetByte;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetChar;

public class OffsetFactory {
    protected static final Log LOG = LogFactory.getLog((String)OffsetFactory.class.getName());

    public static AOffset create(int[] indexes, int nRows) {
        if (nRows < 0) {
            throw new DMLCompressionException("Invalid sizes given");
        }
        if ((float)nRows / (float)indexes.length < 256.0f) {
            return new OffsetByte(indexes);
        }
        return new OffsetChar(indexes);
    }

    public static AOffset readIn(DataInput in) throws IOException {
        OFF_TYPE t = OFF_TYPE.values()[in.readByte()];
        switch (t) {
            case BYTE: {
                return OffsetByte.readFields(in);
            }
            case CHAR: {
                return OffsetChar.readFields(in);
            }
        }
        throw new DMLCompressionException("Unknown input");
    }

    public static long estimateInMemorySize(int size, int nRows) {
        if (size < 0 || nRows < 0) {
            throw new DMLCompressionException("Invalid sizes given: " + size + "  " + nRows);
        }
        if (size == 0) {
            return 8L;
        }
        int avgDiff = nRows / size;
        if (avgDiff < 256) {
            return OffsetByte.getInMemorySize(size - 1);
        }
        return OffsetChar.getInMemorySize(size - 1);
    }

    public static enum OFF_TYPE {
        BYTE,
        CHAR;

    }
}

