/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram;

import java.util.ArrayList;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.parser.WhileStatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.DMLScriptException;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.lineage.LineageDedupUtils;

public class WhileProgramBlock
extends ProgramBlock {
    private ArrayList<Instruction> _predicate;
    private ArrayList<ProgramBlock> _childBlocks;

    public WhileProgramBlock(Program prog, ArrayList<Instruction> predicate) {
        super(prog);
        this._predicate = predicate;
        this._childBlocks = new ArrayList();
    }

    public void addProgramBlock(ProgramBlock childBlock) {
        this._childBlocks.add(childBlock);
    }

    public ArrayList<Instruction> getPredicate() {
        return this._predicate;
    }

    public void setPredicate(ArrayList<Instruction> predicate) {
        this._predicate = predicate;
    }

    @Override
    public ArrayList<ProgramBlock> getChildBlocks() {
        return this._childBlocks;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    private BooleanObject executePredicate(ExecutionContext ec) {
        BooleanObject result = null;
        try {
            if (this._sb != null) {
                WhileStatementBlock wsb = (WhileStatementBlock)this._sb;
                Hop predicateOp = wsb.getPredicateHops();
                boolean recompile = wsb.requiresPredicateRecompilation();
                result = (BooleanObject)this.executePredicate(this._predicate, predicateOp, recompile, Types.ValueType.BOOLEAN, ec);
            } else {
                result = (BooleanObject)this.executePredicate(this._predicate, null, false, Types.ValueType.BOOLEAN, ec);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Failed to evaluate the while predicate.", ex);
        }
        return result;
    }

    @Override
    public void execute(ExecutionContext ec) {
        try {
            MatrixObject.UpdateType[] flags = this.prepareUpdateInPlaceVariables(ec, this._tid);
            if (DMLScript.LINEAGE_DEDUP) {
                ec.getLineage().initializeDedupBlock(this, ec);
            }
            while (this.executePredicate(ec).getBooleanValue()) {
                if (DMLScript.LINEAGE_DEDUP) {
                    ec.getLineage().resetDedupPath();
                }
                if (DMLScript.LINEAGE_DEDUP) {
                    ec.getLineage().createDedupPatch(this, ec);
                }
                for (int i = 0; i < this._childBlocks.size(); ++i) {
                    this._childBlocks.get(i).execute(ec);
                }
                if (!DMLScript.LINEAGE_DEDUP) continue;
                LineageDedupUtils.replaceLineage(ec);
                ec.getLineage().traceCurrentDedupPath(this, ec);
            }
            if (DMLScript.LINEAGE_DEDUP) {
                ec.getLineage().clearDedupBlock();
            }
            this.resetUpdateInPlaceVariableFlags(ec, flags);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating while program block", e);
        }
        this.executeExitInstructions(this._exitInstruction, "while", ec);
    }

    public void setChildBlocks(ArrayList<ProgramBlock> childs) {
        this._childBlocks = childs;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in while program block generated from while statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }
}

