/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.privacy.CheckedConstraintsLog;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;

public class FederatedResponse
implements Serializable {
    private static final long serialVersionUID = 3142180026498695091L;
    private ResponseType _status;
    private Object[] _data;
    private Map<PrivacyConstraint.PrivacyLevel, LongAdder> checkedConstraints;

    public FederatedResponse(ResponseType status) {
        this(status, null);
    }

    public FederatedResponse(ResponseType status, Object[] data) {
        this._status = status;
        this._data = data;
        if (this._status == ResponseType.SUCCESS && data == null) {
            this._status = ResponseType.SUCCESS_EMPTY;
        }
    }

    public FederatedResponse(ResponseType status, Object data) {
        this._status = status;
        this._data = new Object[]{data};
        if (this._status == ResponseType.SUCCESS && data == null) {
            this._status = ResponseType.SUCCESS_EMPTY;
        }
    }

    public boolean isSuccessful() {
        return this._status != ResponseType.ERROR;
    }

    public String getErrorMessage() {
        if (this._data[0] instanceof Throwable) {
            return ExceptionUtils.getFullStackTrace((Throwable)((Throwable)this._data[0]));
        }
        if (this._data[0] instanceof String) {
            return (String)this._data[0];
        }
        return "No readable error message";
    }

    public Object[] getData() throws Exception {
        this.updateCheckedConstraintsLog();
        if (!this.isSuccessful()) {
            this.throwExceptionFromResponse();
        }
        return this._data;
    }

    public void throwExceptionFromResponse() throws Exception {
        for (Object potentialException : this._data) {
            if (potentialException == null || !(potentialException instanceof Exception)) continue;
            throw (Exception)potentialException;
        }
        String errorMessage = this.getErrorMessage();
        if (this.getErrorMessage() != "No readable error message") {
            throw new DMLRuntimeException(errorMessage);
        }
        throw new DMLRuntimeException("Unknown runtime exception in handling of federated request by federated worker.");
    }

    public void setCheckedConstraints(Map<PrivacyConstraint.PrivacyLevel, LongAdder> checkedConstraints) {
        if (checkedConstraints != null && !checkedConstraints.isEmpty()) {
            this.checkedConstraints = new EnumMap<PrivacyConstraint.PrivacyLevel, LongAdder>(PrivacyConstraint.PrivacyLevel.class);
            this.checkedConstraints.putAll(checkedConstraints);
        }
    }

    public void updateCheckedConstraintsLog() {
        if (this.checkedConstraints != null && !this.checkedConstraints.isEmpty()) {
            CheckedConstraintsLog.addCheckedConstraints(this.checkedConstraints);
        }
    }

    public static enum ResponseType {
        SUCCESS,
        SUCCESS_EMPTY,
        ERROR;

    }
}

