/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.operators;

import org.apache.sysds.runtime.functionobjects.And;
import org.apache.sysds.runtime.functionobjects.BitwShiftL;
import org.apache.sysds.runtime.functionobjects.BitwShiftR;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Equals;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.MinusNz;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Multiply2;
import org.apache.sysds.runtime.functionobjects.NotEquals;
import org.apache.sysds.runtime.functionobjects.Power2;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public abstract class ScalarOperator
extends Operator {
    private static final long serialVersionUID = 4547253761093455869L;
    public final ValueFunction fn;
    protected final double _constant;
    private int _k;

    public ScalarOperator(ValueFunction p, double cst) {
        this(p, cst, false);
    }

    protected ScalarOperator(ValueFunction p, double cst, boolean altSparseSafe) {
        this(p, cst, altSparseSafe, 1);
    }

    protected ScalarOperator(ValueFunction p, double cst, boolean altSparseSafe, int numThreads) {
        super(ScalarOperator.isSparseSafeStatic(p) || altSparseSafe || p instanceof NotEquals && cst == 0.0 || p instanceof Equals && cst != 0.0 || p instanceof Minus && cst == 0.0 || p instanceof Builtin && ((Builtin)p).getBuiltinCode() == Builtin.BuiltinCode.MAX && cst <= 0.0 || p instanceof Builtin && ((Builtin)p).getBuiltinCode() == Builtin.BuiltinCode.MIN && cst >= 0.0);
        this.fn = p;
        this._constant = cst;
        this._k = numThreads;
    }

    public double getConstant() {
        return this._constant;
    }

    public void setNumThreads(int k) {
        this._k = k;
    }

    public int getNumThreads() {
        return this._k;
    }

    public abstract ScalarOperator setConstant(double var1);

    public abstract ScalarOperator setConstant(double var1, int var3);

    public abstract double executeScalar(double var1);

    protected static boolean isSparseSafeStatic(ValueFunction fn) {
        return fn instanceof Multiply || fn instanceof Multiply2 || fn instanceof Power2 || fn instanceof And || fn instanceof MinusNz || fn instanceof Builtin && ((Builtin)fn).getBuiltinCode() == Builtin.BuiltinCode.LOG_NZ || fn instanceof BitwShiftL || fn instanceof BitwShiftR;
    }
}

