/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.bitmap;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.util.SortUtils;

public final class MultiColBitmap
extends ABitmap {
    private double[][] _values;

    protected MultiColBitmap(IntArrayList[] offsetsLists, double[][] values, int rows) {
        super(offsetsLists, rows);
        this._values = values;
    }

    public double[][] getValues() {
        return this._values;
    }

    public double[] getValues(int ix) {
        return this._values[ix];
    }

    @Override
    public int getNumNonZerosInOffset(int idx) {
        int nz = 0;
        for (double v : this.getValues(idx)) {
            nz += v == 0.0 ? 0 : 1;
        }
        return nz;
    }

    @Override
    public int getNumValues() {
        return this._values == null ? 0 : this._values.length;
    }

    @Override
    public void sortValuesByFrequency() {
        int numVals = this.getNumValues();
        double[] freq = new double[numVals];
        int[] pos = new int[numVals];
        for (int i = 0; i < numVals; ++i) {
            freq[i] = this.getNumOffsets(i);
            pos[i] = i;
        }
        SortUtils.sortByValue(0, numVals, freq, pos);
        ArrayUtils.reverse((int[])pos);
        double[][] lvalues = new double[numVals][];
        IntArrayList[] loffsets = new IntArrayList[numVals];
        for (int i = 0; i < numVals; ++i) {
            lvalues[i] = this._values[pos[i]];
            loffsets[i] = this._offsetsLists[pos[i]];
        }
        this._values = lvalues;
        this._offsetsLists = loffsets;
    }

    @Override
    public int getNumColumns() {
        return this._values[0].length;
    }

    @Override
    protected void addToString(StringBuilder sb) {
        sb.append("\nValues:");
        for (double[] vv : this._values) {
            sb.append("\n" + Arrays.toString(vv));
        }
    }
}

