/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ADictBasedColGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.PlaceHolderDict;

public interface CLALibSeparator {
    public static final Log LOG = LogFactory.getLog((String)CLALibSeparator.class.getName());

    public static SeparatedGroups split(List<AColGroup> gs) {
        ArrayList<IDictionary> dicts = new ArrayList<IDictionary>(gs.size());
        ArrayList<AColGroup> indexStructures = new ArrayList<AColGroup>(gs.size());
        for (AColGroup g : gs) {
            if (g instanceof ADictBasedColGroup) {
                ADictBasedColGroup dg = (ADictBasedColGroup)g;
                dicts.add(dg.getDictionary());
                indexStructures.add(dg.copyAndSet(new PlaceHolderDict(dg.getNumValues())));
                continue;
            }
            dicts.add(new PlaceHolderDict(-1));
            indexStructures.add(g);
        }
        return new SeparatedGroups(dicts, indexStructures);
    }

    public static List<AColGroup> combine(List<AColGroup> gs, Map<Integer, List<IDictionary>> d, int blen) {
        int gid = 0;
        int s = 0;
        for (List<IDictionary> e : d.values()) {
            s += e.size();
        }
        if (gs.size() != s) {
            throw new RuntimeException("Invalid combine of of groups and dictionaries groups:" + gs.size() + " vs  dicts" + s);
        }
        for (int i = 0; i < d.size(); ++i) {
            List<IDictionary> dd = d.get(i);
            for (int j = 0; j < dd.size(); ++j) {
                IDictionary ddd = dd.get(j);
                AColGroup g = gs.get(gid);
                if (g instanceof ADictBasedColGroup) {
                    ADictBasedColGroup dg = (ADictBasedColGroup)g;
                    gs.set(gid, dg.copyAndSet(ddd));
                }
                ++gid;
            }
        }
        return gs;
    }

    public static class SeparatedGroups {
        public final List<IDictionary> dicts;
        public final List<AColGroup> indexStructures;

        private SeparatedGroups(List<IDictionary> dicts, List<AColGroup> indexStructures) {
            this.dicts = dicts;
            this.indexStructures = indexStructures;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.dicts);
            sb.append(this.indexStructures);
            return sb.toString();
        }
    }
}

