/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.io.Serializable;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockFactory;
import org.apache.sysds.runtime.data.LibTensorAgg;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockFactory;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.util.UtilFunctions;

public class BasicTensorBlock
implements Serializable {
    private static final long serialVersionUID = -7665685894181661833L;
    public static final double SPARSITY_TURN_POINT = 0.4;
    public static final SparseBlock.Type DEFAULT_SPARSEBLOCK = SparseBlock.Type.MCSR;
    protected int[] _dims;
    protected Types.ValueType _vt;
    protected boolean _sparse = true;
    protected long _nnz = 0L;
    protected DenseBlock _denseBlock = null;
    protected SparseBlock _sparseBlock = null;

    public BasicTensorBlock() {
        this(TensorBlock.DEFAULT_VTYPE, (int[])TensorBlock.DEFAULT_DIMS.clone(), true, -1L);
    }

    public BasicTensorBlock(Types.ValueType vt, int[] dims) {
        this(vt, dims, true, -1L);
    }

    public BasicTensorBlock(Types.ValueType vt, int[] dims, boolean sp) {
        this(vt, dims, sp, -1L);
    }

    public BasicTensorBlock(Types.ValueType vt, int[] dims, boolean sp, long estnnz) {
        this._vt = vt;
        this.reset(dims, sp, estnnz, 0.0);
    }

    public BasicTensorBlock(BasicTensorBlock that) {
        this._vt = that.getValueType();
        this.copy(that);
    }

    public BasicTensorBlock(double val) {
        this._vt = TensorBlock.DEFAULT_VTYPE;
        this.reset(new int[]{1, 1}, false, 1L, val);
    }

    public BasicTensorBlock(int[] dims, Types.ValueType vt, double val) {
        this._vt = vt;
        this._dims = dims;
        this.reset(dims, false, val == 0.0 ? 0L : this.getLength(), val);
    }

    public long getLength() {
        return UtilFunctions.prod(this._dims);
    }

    public void reset() {
        this.reset(this._dims, this._sparse, -1L, 0.0);
    }

    public void reset(int[] dims) {
        this.reset(dims, this._sparse, -1L, 0.0);
    }

    public void reset(int[] dims, long estnnz) {
        this.reset(dims, BasicTensorBlock.evalSparseFormatInMemory(dims, estnnz), estnnz, 0.0);
    }

    public void reset(int[] dims, boolean sp) {
        this.reset(dims, sp, -1L, 0.0);
    }

    public void reset(int[] dims, boolean sp, long estnnz) {
        this.reset(dims, sp, estnnz, 0.0);
    }

    private void reset(int[] dims, boolean sp, long estnnz, double val) {
        if (dims.length < 2) {
            throw new DMLRuntimeException("Invalid number of tensor dimensions: " + dims.length);
        }
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] >= 0) continue;
            throw new DMLRuntimeException("Invalid " + i + "th dimensions: " + dims[i]);
        }
        this._dims = dims;
        this._sparse = sp;
        long l = this._nnz = val == 0.0 ? 0L : this.getLength();
        if (this._sparse) {
            this.resetSparse();
        } else {
            this.resetDense(val);
        }
    }

    private void resetSparse() {
        if (this._sparseBlock == null) {
            return;
        }
        this._sparseBlock.reset(-1, this.getDim(2));
    }

    private void resetDense(double val) {
        if (this._denseBlock != null) {
            this._denseBlock.reset(this._dims, val);
        } else if (val != 0.0) {
            this.allocateDenseBlock(false);
            this._denseBlock.set(val);
        } else {
            this.allocateDenseBlock(true);
        }
    }

    public long recomputeNonZeros() {
        if (this._sparse && this._sparseBlock != null) {
            throw new DMLRuntimeException("Sparse tensor block not supported");
        }
        if (!this._sparse && this._denseBlock != null) {
            this._nnz = this._denseBlock.countNonZeros();
        }
        return this._nnz;
    }

    public boolean isAllocated() {
        return this._sparse ? this._sparseBlock != null : this._denseBlock != null;
    }

    public BasicTensorBlock allocateDenseBlock() {
        this.allocateDenseBlock(true);
        return this;
    }

    public BasicTensorBlock allocateBlock() {
        if (this._sparse) {
            this.allocateSparseBlock();
        } else {
            this.allocateDenseBlock();
        }
        return this;
    }

    public boolean allocateDenseBlock(boolean clearNNZ) {
        boolean reset;
        long limit = this.getLength();
        boolean bl = reset = this._denseBlock == null || this._denseBlock.capacity() < limit;
        if (this._denseBlock == null) {
            this._denseBlock = DenseBlockFactory.createDenseBlock(this._vt, this._dims);
        } else if (this._denseBlock.capacity() < limit) {
            this._denseBlock.reset(this._dims);
        }
        if (clearNNZ) {
            this._nnz = 0L;
        }
        this._sparse = false;
        return reset;
    }

    public boolean allocateSparseBlock() {
        return this.allocateSparseBlock(true);
    }

    public boolean allocateSparseBlock(boolean clearNNZ) {
        boolean reset;
        boolean bl = reset = this._sparseBlock == null || this._sparseBlock.numRows() < this.getDim(0);
        if (reset) {
            this._sparseBlock = SparseBlockFactory.createSparseBlock(DEFAULT_SPARSEBLOCK, this.getDim(0));
        }
        if (clearNNZ) {
            this._nnz = 0L;
        }
        return reset;
    }

    public Types.ValueType getValueType() {
        return this._vt;
    }

    public long getNonZeros() {
        return this._nnz;
    }

    public int getNumRows() {
        return this.getDim(0);
    }

    public int getNumColumns() {
        return this.getDim(1);
    }

    public int getNumDims() {
        return this._dims.length;
    }

    public int getDim(int i) {
        return this._dims[i];
    }

    public int[] getDims() {
        return this._dims;
    }

    public boolean isSparse() {
        return this._sparse;
    }

    public boolean isEmpty(boolean safe) {
        boolean ret = false;
        if (this._sparse && this._sparseBlock == null) {
            ret = true;
        } else if (!this._sparse && this._denseBlock == null) {
            ret = true;
        }
        if (this._nnz == 0L) {
            if (safe) {
                this.recomputeNonZeros();
            }
            ret = this._nnz == 0L;
        }
        return ret;
    }

    public DenseBlock getDenseBlock() {
        return this._denseBlock;
    }

    public SparseBlock getSparseBlock() {
        return this._sparseBlock;
    }

    public Object get(int[] ix) {
        if (this._sparse) {
            throw new NotImplementedException();
        }
        switch (this._vt) {
            case FP64: {
                return this._denseBlock.get(ix);
            }
            case FP32: {
                return Float.valueOf((float)this._denseBlock.get(ix));
            }
            case INT64: {
                return this._denseBlock.getLong(ix);
            }
            case INT32: {
                return (int)this._denseBlock.getLong(ix);
            }
            case BOOLEAN: {
                return this._denseBlock.get(ix) != 0.0;
            }
            case STRING: {
                return this._denseBlock.getString(ix);
            }
        }
        throw new DMLRuntimeException("Unsupported value type: " + this._vt);
    }

    public double get(int r, int c) {
        if (this.getNumDims() != 2) {
            throw new DMLRuntimeException("BasicTensor.get(int,int) dimension mismatch: expected=2 actual=" + this.getNumDims());
        }
        if (this._sparse) {
            throw new NotImplementedException();
        }
        return this._denseBlock.get(r, c);
    }

    public void set(int[] ix, Object v) {
        if (this._sparse) {
            throw new NotImplementedException();
        }
        if (v != null) {
            if (v instanceof Double) {
                double old = this._denseBlock.get(ix);
                this._denseBlock.set(ix, (Double)v);
                this._nnz += (long)((old == 0.0 ? 0 : -1) + ((Double)v == 0.0 ? 0 : 1));
            } else if (v instanceof Float) {
                double old = this._denseBlock.get(ix);
                this._denseBlock.set(ix, ((Float)v).floatValue());
                this._nnz += (long)((old == 0.0 ? 0 : -1) + (((Float)v).floatValue() == 0.0f ? 0 : 1));
            } else if (v instanceof Long) {
                long old = this._denseBlock.getLong(ix);
                this._denseBlock.set(ix, (Long)v);
                this._nnz += (long)((old == 0L ? 0 : -1) + ((Long)v == 0L ? 0 : 1));
            } else if (v instanceof Integer) {
                long old = this._denseBlock.getLong(ix);
                this._denseBlock.set(ix, ((Integer)v).intValue());
                this._nnz += (long)((old == 0L ? 0 : -1) + ((Integer)v == 0 ? 0 : 1));
            } else if (v instanceof Boolean) {
                long old = this._denseBlock.getLong(ix);
                this._denseBlock.set(ix, (Boolean)v != false ? 1.0 : 0.0);
                this._nnz += (long)((old == 0L ? 0 : -1) + ((Boolean)v == false ? 0 : 1));
            } else if (v instanceof String) {
                String old = this._denseBlock.getString(ix);
                if (old != null && !old.isEmpty()) {
                    --this._nnz;
                }
                this._denseBlock.set(ix, (String)v);
                if (!((String)v).isEmpty()) {
                    ++this._nnz;
                }
            } else {
                throw new DMLRuntimeException("BasicTensor.set(int[],Object) is not implemented for the given Object");
            }
        }
    }

    public void set(int r, int c, double v) {
        if (this.getNumDims() != 2) {
            throw new DMLRuntimeException("BasicTensor.set(int,int,double) dimension mismatch: expected=2 actual=" + this.getNumDims());
        }
        if (this._sparse) {
            throw new NotImplementedException();
        }
        double old = this._denseBlock.get(r, c);
        this._denseBlock.set(r, c, v);
        this._nnz += (long)((old == 0.0 ? 0 : -1) + (v == 0.0 ? 0 : 1));
    }

    public void set(double v) {
        if (this._sparse) {
            throw new NotImplementedException();
        }
        this._denseBlock.set(v);
        this._nnz = v == 0.0 ? 0L : this.getLength();
    }

    public void set(Object v) {
        if (this._sparse) {
            throw new NotImplementedException();
        }
        if (v instanceof Double) {
            this._denseBlock.set((Double)v);
            this._nnz += (long)((Double)v == 0.0 ? 0 : 1);
        } else if (v instanceof Float) {
            this._denseBlock.set(((Float)v).floatValue());
            this._nnz += (long)(((Float)v).floatValue() == 0.0f ? 0 : 1);
        } else if (v instanceof Long) {
            this._denseBlock.set(((Long)v).longValue());
            this._nnz += (long)((Long)v == 0L ? 0 : 1);
        } else if (v instanceof Integer) {
            this._denseBlock.set(((Integer)v).intValue());
            this._nnz += (long)((Integer)v == 0 ? 0 : 1);
        } else if (v instanceof Boolean) {
            this._denseBlock.set((Boolean)v != false ? 1.0 : 0.0);
            this._nnz += (long)((Boolean)v == false ? 0 : 1);
        } else if (v instanceof String) {
            this._denseBlock.set((String)v);
            this._nnz += (long)(((String)v).isEmpty() ? 0 : 1);
        } else {
            throw new DMLRuntimeException("BasicTensor.set(Object) is not implemented for the given Object");
        }
    }

    public void set(BasicTensorBlock other) {
        if (this._sparse) {
            throw new NotImplementedException();
        }
        if (other.isSparse()) {
            throw new NotImplementedException();
        }
        this._denseBlock.set(0, this._dims[0], 0, this._denseBlock.getCumODims(0), other.getDenseBlock());
        this._nnz = other._nnz;
    }

    public void set(MatrixBlock other) {
        if (this._sparse) {
            throw new NotImplementedException();
        }
        if (other.isInSparseFormat()) {
            if (other.isEmpty()) {
                this._denseBlock.set(0.0);
            } else {
                other.sparseToDense();
                this._denseBlock.set(0, this._dims[0], 0, this._denseBlock.getCumODims(0), other.getDenseBlock());
                this._nnz = other.getNonZeros();
            }
        } else {
            this._denseBlock.set(0, this._dims[0], 0, this._denseBlock.getCumODims(0), other.getDenseBlock());
            this._nnz = other.getNonZeros();
        }
    }

    public void copy(BasicTensorBlock that) {
        this._dims = (int[])that._dims.clone();
        this._sparse = that._sparse;
        this._nnz = that._nnz;
        if (that.isAllocated()) {
            if (!this._sparse) {
                this.copyDenseToDense(that);
            } else {
                throw new NotImplementedException();
            }
        }
    }

    public BasicTensorBlock copyShallow(BasicTensorBlock that) {
        this._dims = (int[])that._dims.clone();
        this._sparse = that._sparse;
        this._nnz = that._nnz;
        if (!this._sparse) {
            this._denseBlock = that._denseBlock;
        } else {
            this._sparseBlock = that._sparseBlock;
        }
        return this;
    }

    private void copyDenseToDense(BasicTensorBlock that) {
        this._nnz = that._nnz;
        if (that.isEmpty(false)) {
            if (this._denseBlock != null) {
                this._denseBlock.reset(that._dims);
            } else {
                this._denseBlock = DenseBlockFactory.createDenseBlock(that._vt, that._dims);
            }
        }
        this.allocateDenseBlock(false);
        this._denseBlock.set(that._denseBlock);
    }

    public void copy(int[] lower, int[] upper, BasicTensorBlock src) {
        if (src.isEmpty(false)) {
            return;
        }
        DenseBlock db = src.getDenseBlock();
        int rowLower = lower[0];
        int rowUpper = upper[0] + 1;
        int columnLower = lower[lower.length - 1];
        int columnUpper = upper[upper.length - 1];
        for (int i = 1; i < lower.length - 1; ++i) {
            columnLower += lower[i] * db.getCumODims(i);
            columnUpper += upper[i] * db.getCumODims(i);
        }
        if (columnLower == columnUpper || columnUpper == 0) {
            --rowUpper;
            columnUpper = db.getCumODims(0);
        }
        this._denseBlock.set(rowLower, rowUpper, columnLower, columnUpper, db);
    }

    private static boolean evalSparseFormatInMemory(int[] dims, long estnnz) {
        return false;
    }

    public BasicTensorBlock aggregateUnaryOperations(AggregateUnaryOperator op, BasicTensorBlock result) {
        if (op.aggOp.increOp.fn instanceof KahanPlus) {
            op = new AggregateUnaryOperator(new AggregateOperator(0.0, Plus.getPlusFnObject()), op.indexFn, op.getNumThreads());
        }
        int dim0 = 1;
        int dim1 = 1;
        if (op.aggOp.existsCorrection()) {
            dim1 = 2;
        }
        if (result == null || result._vt != this._vt) {
            result = new BasicTensorBlock(this._vt, new int[]{dim0, dim1}, false);
        } else {
            result.reset(new int[]{dim0, dim1}, false);
        }
        if (LibTensorAgg.isSupportedUnaryAggregateOperator(op)) {
            if (!(op.indexFn instanceof ReduceAll)) {
                throw new DMLRuntimeException("Only ReduceAll UnaryAggregationOperators are supported for tensor");
            }
        } else {
            throw new DMLRuntimeException("Current UnaryAggregationOperator not supported for tensor");
        }
        LibTensorAgg.aggregateUnaryTensor(this, result, op);
        return result;
    }

    public void incrementalAggregate(AggregateOperator aggOp, BasicTensorBlock partialResult) {
        if (aggOp.existsCorrection() || !(aggOp.increOp.fn instanceof Plus)) {
            throw new DMLRuntimeException("Correction not supported. correctionLocation: " + aggOp.correction);
        }
        LibTensorAgg.aggregateBinaryTensor(partialResult, this, aggOp);
    }
}

