/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.cocode.CoCodeGreedy;
import org.apache.sysds.runtime.compress.cocode.CoCodePriorityQue;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.utils.stats.Timing;

public class CoCodeHybrid
extends AColumnCoCoder {
    protected CoCodeHybrid(AComEst sizeEstimator, ACostEstimate costEstimator, CompressionSettings cs) {
        super(sizeEstimator, costEstimator, cs);
    }

    @Override
    protected CompressedSizeInfo coCodeColumns(CompressedSizeInfo colInfos, int k) {
        int PriorityQueGoal;
        int startSize = colInfos.getInfo().size();
        int pqColumnThreashold = Math.max(128, this._sest.getNumColumns() / startSize * 100);
        if (startSize == 1) {
            return colInfos;
        }
        if (startSize <= 16) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Hybrid chose to do greedy CoCode because of few columns");
            }
            CoCodeGreedy gd = new CoCodeGreedy(this._sest, this._cest, this._cs);
            return colInfos.setInfo(gd.combine(colInfos.getInfo(), k));
        }
        if (startSize > 1000) {
            CoCodePriorityQue pq = new CoCodePriorityQue(this._sest, this._cest, this._cs, pqColumnThreashold);
            return colInfos.setInfo(pq.join(colInfos.getInfo(), 1, k));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Using Hybrid CoCode Strategy: ");
        }
        if ((PriorityQueGoal = startSize / 5) > 30) {
            Timing time = new Timing(true);
            CoCodePriorityQue pq = new CoCodePriorityQue(this._sest, this._cest, this._cs, pqColumnThreashold);
            colInfos.setInfo(pq.join(colInfos.getInfo(), PriorityQueGoal, k));
            int pqSize = colInfos.getInfo().size();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Que based time: " + time.stop()));
            }
            if (pqSize < PriorityQueGoal || pqSize < startSize && this._cest instanceof ComputationCostEstimator) {
                CoCodeGreedy gd = new CoCodeGreedy(this._sest, this._cest, this._cs);
                colInfos.setInfo(gd.combine(colInfos.getInfo(), k));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Greedy time:     " + time.stop()));
                }
            }
            return colInfos;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using only Greedy based since Nr Column groups: " + startSize + " is not large enough"));
        }
        CoCodeGreedy gd = new CoCodeGreedy(this._sest, this._cest, this._cs);
        colInfos.setInfo(gd.combine(colInfos.getInfo(), k));
        return colInfos;
    }
}

