/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.lineage.LineageGPUCacheEviction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class EvictCPInstruction
extends UnaryCPInstruction {
    private EvictCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.EvictLineageCache, op, in, out, opcode, istr);
    }

    public static EvictCPInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 3);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new EvictCPInstruction(null, in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        ScalarObject fr = ec.getScalarInput(this.input1);
        double evictFrac = (double)fr.getLongValue() / 100.0;
        LineageGPUCacheEviction.removeAllEntries(evictFrac);
    }
}

