/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.spark.SparkException;
import org.apache.spark.util.SparkFatalException;
import org.apache.spark.util.SparkThreadUtils$;
import org.sparkproject.guava.util.concurrent.ThreadFactoryBuilder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Awaitable;
import scala.concurrent.CanAwait;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileObjectRef;
import scala.util.control.NonFatal$;

public final class ThreadUtils$ {
    public static ThreadUtils$ MODULE$;
    private final ExecutionContextExecutorService sameThreadExecutionContext;

    static {
        new ThreadUtils$();
    }

    private ExecutionContextExecutorService sameThreadExecutionContext() {
        return this.sameThreadExecutionContext;
    }

    public ExecutorService sameThreadExecutorService() {
        return new AbstractExecutorService(){
            private final ReentrantLock lock;
            private final Condition termination;
            private int runningTasks;
            private boolean serviceIsShutdown;

            private ReentrantLock lock() {
                return this.lock;
            }

            private Condition termination() {
                return this.termination;
            }

            private int runningTasks() {
                return this.runningTasks;
            }

            private void runningTasks_$eq(int x$1) {
                this.runningTasks = x$1;
            }

            private boolean serviceIsShutdown() {
                return this.serviceIsShutdown;
            }

            private void serviceIsShutdown_$eq(boolean x$1) {
                this.serviceIsShutdown = x$1;
            }

            public void shutdown() {
                this.lock().lock();
                try {
                    this.serviceIsShutdown_$eq(true);
                }
                finally {
                    this.lock().unlock();
                }
            }

            public java.util.List<Runnable> shutdownNow() {
                this.shutdown();
                return Collections.emptyList();
            }

            public boolean isShutdown() {
                boolean bl;
                this.lock().lock();
                try {
                    bl = this.serviceIsShutdown();
                }
                finally {
                    this.lock().unlock();
                }
                return bl;
            }

            public synchronized boolean isTerminated() {
                boolean bl;
                this.lock().lock();
                try {
                    bl = this.serviceIsShutdown() && this.runningTasks() == 0;
                }
                finally {
                    this.lock().unlock();
                }
                return bl;
            }

            public boolean awaitTermination(long timeout, TimeUnit unit) {
                boolean bl;
                long nanos = unit.toNanos(timeout);
                this.lock().lock();
                try {
                    while (nanos > 0L && !this.isTerminated()) {
                        nanos = this.termination().awaitNanos(nanos);
                    }
                    bl = this.isTerminated();
                }
                finally {
                    this.lock().unlock();
                }
                return bl;
            }

            public void execute(Runnable command) {
                this.lock().lock();
                try {
                    if (this.isShutdown()) {
                        throw new RejectedExecutionException("Executor already shutdown");
                    }
                    this.runningTasks_$eq(this.runningTasks() + 1);
                }
                finally {
                    this.lock().unlock();
                }
                try {
                    command.run();
                }
                finally {
                    this.lock().lock();
                    try {
                        this.runningTasks_$eq(this.runningTasks() - 1);
                        if (this.isTerminated()) {
                            this.termination().signalAll();
                        }
                    }
                    finally {
                        this.lock().unlock();
                    }
                }
            }
            {
                this.lock = new ReentrantLock();
                this.termination = this.lock().newCondition();
                this.runningTasks = 0;
                this.serviceIsShutdown = false;
            }
        };
    }

    public ExecutionContextExecutor sameThread() {
        return this.sameThreadExecutionContext();
    }

    public ThreadFactory namedThreadFactory(String prefix) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(new StringBuilder(3).append(prefix).append("-%d").toString()).build();
    }

    public ThreadPoolExecutor newDaemonCachedThreadPool(String prefix) {
        ThreadFactory threadFactory = this.namedThreadFactory(prefix);
        return (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
    }

    public ThreadPoolExecutor newDaemonCachedThreadPool(String prefix, int maxThreadNumber, int keepAliveSeconds) {
        ThreadFactory threadFactory = this.namedThreadFactory(prefix);
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(maxThreadNumber, maxThreadNumber, (long)keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        threadPool.allowCoreThreadTimeOut(true);
        return threadPool;
    }

    public int newDaemonCachedThreadPool$default$3() {
        return 60;
    }

    public ThreadPoolExecutor newDaemonFixedThreadPool(int nThreads, String prefix) {
        ThreadFactory threadFactory = this.namedThreadFactory(prefix);
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(nThreads, threadFactory);
    }

    public ThreadPoolExecutor newDaemonSingleThreadExecutor(String threadName) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).build();
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(1, threadFactory);
    }

    public ThreadPoolExecutor newDaemonSingleThreadExecutorWithRejectedExecutionHandler(String threadName, int taskQueueCapacity, RejectedExecutionHandler rejectedExecutionHandler) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).build();
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(taskQueueCapacity), threadFactory, rejectedExecutionHandler);
    }

    public ScheduledExecutorService newDaemonSingleThreadScheduledExecutor(String threadName) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).build();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    public ScheduledExecutorService newDaemonThreadPoolScheduledExecutor(String threadNamePrefix, int numThreads) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(new StringBuilder(3).append(threadNamePrefix).append("-%d").toString()).build();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(numThreads, threadFactory);
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    public <T> T runInNewThread(String threadName, boolean isDaemon, Function0<T> body2) {
        VolatileObjectRef exception = VolatileObjectRef.create((Object)None$.MODULE$);
        VolatileObjectRef result = VolatileObjectRef.create(null);
        Thread thread = new Thread(threadName, result, body2, exception){
            private final VolatileObjectRef result$1;
            private final Function0 body$1;
            private final VolatileObjectRef exception$1;

            public void run() {
                try {
                    this.result$1.elem = this.body$1.apply();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.exception$1.elem = new Some((Object)e);
                    }
                    throw throwable;
                }
            }
            {
                this.result$1 = result$1;
                this.body$1 = body$1;
                this.exception$1 = exception$1;
                super(threadName$1);
            }
        };
        thread.setDaemon(isDaemon);
        thread.start();
        thread.join();
        Option option = (Option)exception.elem;
        if (option instanceof Some) {
            Some some = (Some)option;
            Throwable realException = (Throwable)some.value();
            StackTraceElement[] baseStackTrace = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).dropWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ThreadUtils$.$anonfun$runInNewThread$1(x$1))))).drop(1);
            StackTraceElement[] extraStackTrace = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])realException.getStackTrace())).takeWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ThreadUtils$.$anonfun$runInNewThread$2(x$2)));
            StackTraceElement placeHolderStackElem = new StackTraceElement(new StringBuilder(36).append("... run in separate thread using ").append(new StringOps(Predef$.MODULE$.augmentString(this.getClass().getName())).stripSuffix("$")).append(" ..").toString(), " ", "", -1);
            StackTraceElement[] finalStackTrace = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])extraStackTrace)).$plus$plus((GenTraversableOnce)new .colon.colon((Object)placeHolderStackElem, (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StackTraceElement.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])baseStackTrace)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StackTraceElement.class)));
            realException.setStackTrace(finalStackTrace);
            throw realException;
        }
        if (None$.MODULE$.equals(option)) {
            return (T)result.elem;
        }
        throw new MatchError((Object)option);
    }

    public <T> boolean runInNewThread$default$2() {
        return true;
    }

    public ForkJoinPool newForkJoinPool(String prefix, int maxThreadNumber) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(prefix){
            public final String prefix$1;

            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                return new ForkJoinWorkerThread(this, pool){
                    {
                        super(pool$1);
                        this.setName(new StringBuilder(1).append($outer.prefix$1).append("-").append(super.getName()).toString());
                    }
                };
            }
            {
                this.prefix$1 = prefix$1;
            }
        };
        return new ForkJoinPool(maxThreadNumber, factory, null, false);
    }

    public <T> T awaitResult(Awaitable<T> awaitable, Duration atMost) throws SparkException {
        return (T)SparkThreadUtils$.MODULE$.awaitResult(awaitable, atMost);
    }

    public <T> T awaitResult(Future<T> future, Duration atMost) throws SparkException {
        T t;
        try {
            Duration duration = atMost;
            Duration.Infinite infinite = Duration$.MODULE$.Inf();
            Duration duration2 = duration;
            t = !(infinite != null ? !infinite.equals(duration2) : duration2 != null) ? future.get() : future.get(package$.MODULE$.durationToPair(atMost)._1$mcJ$sp(), (TimeUnit)((Object)package$.MODULE$.durationToPair(atMost)._2()));
        }
        catch (Throwable throwable) {
            Throwable t2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SparkFatalException) {
                SparkFatalException sparkFatalException = (SparkFatalException)throwable2;
                throw sparkFatalException.throwable();
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty() && !((t2 = (Throwable)option.get()) instanceof TimeoutException)) {
                throw new SparkException("Exception thrown in awaitResult: ", t2);
            }
            throw throwable;
        }
        return t;
    }

    public <T> Awaitable<T> awaitReady(Awaitable<T> awaitable, Duration atMost) throws SparkException {
        Awaitable awaitable2;
        try {
            CanAwait awaitPermission = null;
            awaitable2 = awaitable.ready(atMost, awaitPermission);
        }
        catch (Throwable throwable) {
            Throwable t;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty() && !((t = (Throwable)option.get()) instanceof TimeoutException)) {
                throw new SparkException("Exception thrown in awaitResult: ", t);
            }
            throw throwable;
        }
        return awaitable2;
    }

    public void shutdown(ExecutorService executor, Duration gracePeriod) {
        executor.shutdown();
        executor.awaitTermination(gracePeriod.toMillis(), TimeUnit.MILLISECONDS);
        if (!executor.isShutdown()) {
            executor.shutdownNow();
            return;
        }
    }

    public Duration shutdown$default$2() {
        return FiniteDuration$.MODULE$.apply(30L, TimeUnit.SECONDS);
    }

    public <I, O> Seq<O> parmap(Seq<I> in, String prefix, int maxThreads, Function1<I, O> f) {
        Seq seq;
        ForkJoinPool pool = this.newForkJoinPool(prefix, maxThreads);
        try {
            ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)pool);
            Seq futures = (Seq)in.map((Function1 & Serializable & scala.Serializable)x -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> f.apply(x), (ExecutionContext)ec), Seq$.MODULE$.canBuildFrom());
            scala.concurrent.Future futureSeq = Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)ec);
            seq = (Seq)this.awaitResult((Awaitable)futureSeq, (Duration)Duration$.MODULE$.Inf());
        }
        finally {
            pool.shutdownNow();
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$runInNewThread$1(StackTraceElement x$1) {
        return !x$1.getClassName().contains(MODULE$.getClass().getSimpleName());
    }

    public static final /* synthetic */ boolean $anonfun$runInNewThread$2(StackTraceElement x$2) {
        return !x$2.getClassName().contains(MODULE$.getClass().getSimpleName());
    }

    private ThreadUtils$() {
        MODULE$ = this;
        this.sameThreadExecutionContext = ExecutionContext$.MODULE$.fromExecutorService(this.sameThreadExecutorService());
    }
}

