/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops.compile.linearization;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.compile.linearization.IDagLinearizer;

public class LinearizerMinIntermediates
extends IDagLinearizer {
    @Override
    public List<Lop> linearize(List<Lop> v) {
        ArrayList<Lop> nodes = new ArrayList<Lop>(v.size());
        List<Lop> lowestLevel = v.stream().filter(l -> l.getOutputs().isEmpty()).collect(Collectors.toList());
        LinkedList<Lop> remaining = new LinkedList<Lop>(v);
        LinearizerMinIntermediates.sortRecursive(nodes, lowestLevel, remaining);
        while (!remaining.isEmpty()) {
            int maxLevel = remaining.stream().mapToInt(Lop::getLevel).max().orElse(-1);
            List<Lop> lowestNodes = remaining.stream().filter(l -> l.getLevel() == maxLevel).collect(Collectors.toList());
            LinearizerMinIntermediates.sortRecursive(nodes, lowestNodes, remaining);
        }
        Collections.reverse(nodes);
        return nodes;
    }

    private static void sortRecursive(List<Lop> result, List<Lop> input, List<Lop> remaining) {
        List memEst = input.stream().distinct().map(l -> new AbstractMap.SimpleEntry<Lop, Long>((Lop)l, l.getOutputs().isEmpty() ? 0L : OptimizerUtils.estimateSizeExactSparsity(l.getOutputParameters().getNumRows(), l.getOutputParameters().getNumCols(), l.getOutputParameters().getNnz()))).sorted(Comparator.comparing(e -> (Long)e.getValue())).collect(Collectors.toList());
        Collections.reverse(memEst);
        for (Map.Entry e2 : memEst) {
            if (result.contains(e2.getKey()) || !result.containsAll(((Lop)e2.getKey()).getOutputs()) && remaining.stream().anyMatch(l -> ((Lop)e2.getKey()).getOutputs().contains(l))) continue;
            result.add((Lop)e2.getKey());
            remaining.remove(e2.getKey());
            LinearizerMinIntermediates.sortRecursive(result, ((Lop)e2.getKey()).getInputs(), remaining);
        }
    }
}

