/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.functionobjects.MinusMultiply;
import org.apache.sysds.runtime.functionobjects.PlusMultiply;
import org.apache.sysds.runtime.matrix.data.LibMatrixTercell;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;

public final class CLALibTernaryOp {
    protected static final Log LOG = LogFactory.getLog((String)CLALibTernaryOp.class.getName());

    private CLALibTernaryOp() {
    }

    public static MatrixBlock ternaryOperations(TernaryOperator op, MatrixBlock m1, MatrixBlock m2, MatrixBlock m3) {
        boolean PM_Or_MM;
        int r1 = m1.getNumRows();
        int r2 = m2.getNumRows();
        int r3 = m3.getNumRows();
        int c1 = m1.getNumColumns();
        int c2 = m2.getNumColumns();
        int c3 = m3.getNumColumns();
        boolean s1 = r1 == 1 && c1 == 1 || m1.isEmpty();
        boolean s2 = r2 == 1 && c2 == 1 || m2.isEmpty();
        boolean s3 = r3 == 1 && c3 == 1 || m3.isEmpty();
        double d1 = s1 ? m1.get(0, 0) : Double.NaN;
        double d2 = s2 ? m2.get(0, 0) : Double.NaN;
        double d3 = s3 ? m3.get(0, 0) : Double.NaN;
        int m = Math.max(Math.max(r1, r2), r3);
        int n = Math.max(Math.max(c1, c2), c3);
        MatrixBlock.ternaryOperationCheck(s1, s2, s3, m, r1, r2, r3, n, c1, c2, c3);
        boolean bl = PM_Or_MM = op.fn instanceof PlusMultiply || op.fn instanceof MinusMultiply;
        if (s1 && s2 && s3) {
            double v = op.fn.execute(d1, d2, d3);
            return CompressedMatrixBlockFactory.createConstant(m, n, v);
        }
        if (PM_Or_MM) {
            if (s2 && d2 == 0.0 || s3 && d3 == 0.0) {
                MatrixBlock ret = m1 instanceof CompressedMatrixBlock ? new CompressedMatrixBlock() : new MatrixBlock();
                ret.copy(m1);
                return ret;
            }
            if (s2 && s3 || s1 && s2 || s1 && s3) {
                LOG.debug((Object)"Ternary operator could be converted to scalar because of constant sides");
            } else if (s2 || s3) {
                BinaryOperator bop = op.setOp2Constant(s2 ? d2 : d3);
                MatrixBlock ret = m1.binaryOperations(bop, s2 ? m3 : m2);
                return ret;
            }
        }
        m1 = CLALibTernaryOp.decompress(op, m1, 1);
        m2 = CLALibTernaryOp.decompress(op, m2, 2);
        m3 = CLALibTernaryOp.decompress(op, m3, 3);
        MatrixBlock ret = new MatrixBlock();
        boolean sparseOutput = MatrixBlock.evalSparseFormatInMemory(m, n, (s1 ? (long)(m * n * (d1 != 0.0 ? 1 : 0)) : m1.getNonZeros()) + Math.min(s2 ? (long)(m * n) : m2.getNonZeros(), s3 ? (long)(m * n) : m3.getNonZeros()));
        ret.reset(m, n, sparseOutput);
        LibMatrixTercell.tercellOp(m1, m2, m3, ret, op);
        ret.examSparsity();
        return ret;
    }

    private static MatrixBlock decompress(TernaryOperator op, MatrixBlock m, int arg) {
        if (m instanceof CompressedMatrixBlock) {
            m = ((CompressedMatrixBlock)m).getUncompressed("Ternary Operator arg " + arg + " " + op.fn.getClass().getSimpleName(), op.getNumThreads());
        }
        return m;
    }
}

