/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ner.mitie;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tika.parser.ner.NERecogniser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MITIENERecogniser
implements NERecogniser {
    public static final String MODEL_PROP_NAME = "ner.mitie.model";
    public static final Set<String> ENTITY_TYPES = new HashSet<String>(){
        {
            this.add("PERSON");
            this.add("LOCATION");
            this.add("ORGANIZATION");
            this.add("MISC");
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(MITIENERecogniser.class);
    private static final String NamedEntityExtractor_Class = "edu.mit.ll.mitie.NamedEntityExtractor";
    private boolean available = false;
    private Object extractorInstance;

    public MITIENERecogniser() {
        this(System.getProperty(MODEL_PROP_NAME));
    }

    public MITIENERecogniser(String modelPath) {
        try {
            if (!new File(modelPath).exists()) {
                LOG.warn("{} does not exist", (Object)modelPath);
            } else {
                Class<?> namedEntityExtractorClass = Class.forName(NamedEntityExtractor_Class);
                this.extractorInstance = namedEntityExtractorClass.getDeclaredConstructor(String.class).newInstance(modelPath);
                this.available = true;
            }
        }
        catch (Exception e) {
            LOG.warn("{} while trying to load the model from {}", (Object)e.getMessage(), (Object)modelPath);
        }
        LOG.info("Available for service ? {}", (Object)this.available);
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public Set<String> getEntityTypes() {
        return ENTITY_TYPES;
    }

    @Override
    public Map<String, Set<String>> recognise(String text) {
        HashMap<String, Set<String>> names = new HashMap<String, Set<String>>();
        try {
            Class<?> stringVectorClass = Class.forName("edu.mit.ll.mitie.StringVector");
            Class<?> entityMentionVectorClass = Class.forName("edu.mit.ll.mitie.EntityMentionVector");
            Class<?> entityMentionClass = Class.forName("edu.mit.ll.mitie.EntityMention");
            Object entityMentionObject = null;
            Class<?> globalClass = Class.forName("edu.mit.ll.mitie.global");
            Object stringVectorObject = this.extractorInstance.getClass().getMethod("getPossibleNerTags", new Class[0]).invoke(this.extractorInstance, new Object[0]);
            long size = (Long)stringVectorClass.getMethod("size", new Class[0]).invoke(stringVectorObject, new Object[0]);
            ArrayList<String> possibleTags = new ArrayList<String>();
            for (long i = 0L; i < size; ++i) {
                String t = (String)stringVectorClass.getMethod("get", Integer.TYPE).invoke(stringVectorObject, (int)i);
                possibleTags.add(t);
            }
            Method tokenize = globalClass.getMethod("tokenize", String.class);
            stringVectorObject = tokenize.invoke(globalClass, text);
            ArrayList<String> stringVector = new ArrayList<String>();
            size = (Long)stringVectorClass.getMethod("size", new Class[0]).invoke(stringVectorObject, new Object[0]);
            for (long i = 0L; i < size; ++i) {
                String t = (String)stringVectorClass.getMethod("get", Integer.TYPE).invoke(stringVectorObject, (int)i);
                stringVector.add(t);
            }
            Method extractEntities = this.extractorInstance.getClass().getMethod("extractEntities", stringVectorClass);
            Object entities = extractEntities.invoke(this.extractorInstance, stringVectorObject);
            size = (Long)entityMentionVectorClass.getMethod("size", new Class[0]).invoke(entities, new Object[0]);
            for (long i = 0L; i < size; ++i) {
                entityMentionObject = entityMentionVectorClass.getMethod("get", Integer.TYPE).invoke(entities, (int)i);
                int tag_index = (Integer)entityMentionClass.getMethod("getTag", new Class[0]).invoke(entityMentionObject, new Object[0]);
                String tag = (String)possibleTags.get(tag_index);
                Set<String> x = new HashSet();
                if (names.containsKey(tag)) {
                    x = (Set)names.get(tag);
                } else {
                    names.put(tag, x);
                }
                int end = (Integer)entityMentionClass.getMethod("getEnd", new Class[0]).invoke(entityMentionObject, new Object[0]);
                StringBuilder match = new StringBuilder();
                for (int start = ((Integer)entityMentionClass.getMethod("getStart", new Class[0]).invoke(entityMentionObject, new Object[0])).intValue(); start < end; ++start) {
                    match.append((String)stringVector.get(start)).append(" ");
                }
                x.add(match.toString().trim());
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        return names;
    }
}

