/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.PolarStereographicA;
import org.apache.sis.internal.referencing.provider.PolarStereographicB;
import org.apache.sis.internal.referencing.provider.PolarStereographicC;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class PolarStereographic
extends ConformalProjection {
    private static final long serialVersionUID = -6635298308431138524L;

    public PolarStereographic(OperationMethod operationMethod, Parameters parameters) {
        this(PolarStereographic.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        Variant variant = (Variant)PolarStereographic.variant((OperationMethod)operationMethod, (ProjectionVariant[])Variant.values(), (ProjectionVariant)Variant.B);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        ParameterDescriptor<Double> parameterDescriptor = PolarStereographicA.FALSE_EASTING;
        ParameterDescriptor<Double> parameterDescriptor2 = PolarStereographicA.FALSE_NORTHING;
        if (variant == Variant.C) {
            parameterDescriptor = PolarStereographicC.EASTING_AT_FALSE_ORIGIN;
            parameterDescriptor2 = PolarStereographicC.NORTHING_AT_FALSE_ORIGIN;
        }
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, parameterDescriptor);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, parameterDescriptor2);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, PolarStereographicA.SCALE_FACTOR);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, variant == Variant.A ? PolarStereographicA.LONGITUDE_OF_ORIGIN : PolarStereographicB.LONGITUDE_OF_ORIGIN);
        return new Initializer(operationMethod, parameters, enumMap, variant);
    }

    private PolarStereographic(Initializer initializer) {
        super(initializer);
        DoubleDouble doubleDouble;
        DoubleDouble doubleDouble2;
        Variant variant = (Variant)initializer.variant;
        double d = variant == Variant.A ? initializer.getAndStore(PolarStereographicA.LATITUDE_OF_ORIGIN) : initializer.getAndStore(PolarStereographicA.LATITUDE_OF_ORIGIN, variant == Variant.NORTH ? 90.0 : (variant == Variant.SOUTH ? -90.0 : Double.NaN));
        if (Math.abs(Math.abs(d) - 90.0) > 8.999280057595393E-8) {
            throw new IllegalArgumentException(Resources.format((short)25, PolarStereographicA.LATITUDE_OF_ORIGIN.getName(), d));
        }
        double d2 = variant == Variant.B || variant == Variant.C || Double.isNaN(d) ? initializer.getAndStore(PolarStereographicB.STANDARD_PARALLEL) : initializer.getAndStore(PolarStereographicB.STANDARD_PARALLEL, d);
        boolean bl = MathFunctions.isPositive(d2);
        if (bl) {
            d2 = -d2;
        }
        if (Math.abs((d2 = Math.toRadians(d2)) + 1.5707963267948966) < 1.5706706731410455E-9) {
            doubleDouble2 = new DoubleDouble(2.0 / Math.sqrt(Math.pow(1.0 + this.eccentricity, 1.0 + this.eccentricity) * Math.pow(1.0 - this.eccentricity, 1.0 - this.eccentricity)));
            doubleDouble = null;
        } else {
            double d3 = Math.sin(d2);
            double d4 = initializer.scaleAt\u03c6(d3, Math.cos(d2));
            doubleDouble2 = new DoubleDouble(d4 / this.exp\u03a8(d2, this.eccentricity * d3));
            doubleDouble = variant == Variant.C ? new DoubleDouble(-d4) : null;
        }
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS.convertBefore(0, doubleDouble2, null);
        matrixSIS.convertBefore(1, doubleDouble2, doubleDouble);
        if (bl) {
            DoubleDouble doubleDouble3 = new DoubleDouble(-1.0);
            MatrixSIS matrixSIS2 = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
            matrixSIS2.convertAfter(1, doubleDouble3, null);
            matrixSIS.convertBefore(1, doubleDouble3, null);
        }
    }

    PolarStereographic(PolarStereographic polarStereographic) {
        super(polarStereographic);
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        PolarStereographic polarStereographic = this;
        if (this.eccentricity == 0.0 && this.getClass() == PolarStereographic.class) {
            polarStereographic = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, polarStereographic);
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition domainDefinition) {
        return Optional.of(new Envelope2D(null, -Math.PI, -1.5707963267948966, Math.PI * 2, 1.5707963267948966));
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double d5 = Math.sin(d2);
        double d6 = this.exp\u03a8(d2, this.eccentricity * d5);
        double d7 = d6 * d3;
        double d8 = d6 * d4;
        if (dArray2 != null) {
            dArray2[n2] = d7;
            dArray2[n2 + 1] = d8;
        }
        if (!bl) {
            return null;
        }
        double d9 = d6 * this.dy_d\u03c6(d5, Math.cos(d2));
        return new Matrix2(d8, d9 * d3, -d7, d9 * d4);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        dArray2[n2] = Math.atan2(d, d2);
        dArray2[n2 + 1] = -this.\u03c6(Formulas.fastHypot(d, d2));
    }

    private static enum Variant implements ProjectionVariant
    {
        A(".*\\bvariant\\s*A\\b.*", "9810"),
        B(".*\\bvariant\\s*B\\b.*", "9829"),
        C(".*\\bvariant\\s*C\\b.*", "9830"),
        NORTH(".*\\bNorth\\b.*", null),
        SOUTH(".*\\bSouth\\b.*", null);

        private final Pattern operationName;
        private final String identifier;

        private Variant(String string2, String string3) {
            this.operationName = Pattern.compile(string2, 2);
            this.identifier = string3;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    static final class Spherical
    extends PolarStereographic {
        private static final long serialVersionUID = 1655096575897215547L;

        protected Spherical(PolarStereographic polarStereographic) {
            super(polarStereographic);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            double d5 = Math.tan(0.7853981633974483 + 0.5 * d2);
            double d6 = d5 * d3;
            double d7 = d5 * d4;
            if (dArray2 != null) {
                dArray2[n2] = d6;
                dArray2[n2 + 1] = d7;
            }
            if (!bl) {
                return null;
            }
            double d8 = d5 / Math.cos(d2);
            return new Matrix2(d7, d8 * d3, -d6, d8 * d4);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.hypot(d, d2);
            dArray2[n2] = Math.atan2(d, d2);
            dArray2[n2 + 1] = 2.0 * Math.atan(d3) - 1.5707963267948966;
        }
    }
}

