/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.AbstractResource;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.storage.aggregate.CoverageAggregator;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupByTransform;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;

final class GroupAggregate
extends AbstractResource
implements Aggregate,
AggregatedResource {
    private static final int KEEP_ALIVE = 2;
    private String name;
    private final Resource[] components;
    private boolean componentsAreLeaves;
    private ImmutableEnvelope envelope;
    private boolean envelopeIsEvaluated;
    List<SampleDimension> sampleDimensions;

    GroupAggregate(StoreListeners storeListeners, String string, int n) {
        super(storeListeners, n < 2);
        this.components = new Resource[n];
        this.name = string;
    }

    GroupAggregate(StoreListeners storeListeners, String string, GridCoverageResource[] gridCoverageResourceArray, List<SampleDimension> list) {
        super(storeListeners, true);
        this.name = string;
        this.components = gridCoverageResourceArray;
        this.componentsAreLeaves = true;
        this.sampleDimensions = list;
    }

    private GroupAggregate(GroupAggregate groupAggregate, Resource[] resourceArray) {
        super(groupAggregate.listeners, true);
        this.name = groupAggregate.name;
        this.envelope = groupAggregate.envelope;
        this.envelopeIsEvaluated = groupAggregate.envelopeIsEvaluated;
        this.sampleDimensions = groupAggregate.sampleDimensions;
        this.componentsAreLeaves = groupAggregate.componentsAreLeaves;
        this.components = resourceArray;
    }

    @Override
    public final synchronized Resource apply(MergeStrategy mergeStrategy) {
        boolean bl = false;
        Resource[] resourceArray = (Resource[])this.components.clone();
        for (int i = 0; i < resourceArray.length; ++i) {
            Resource resource = resourceArray[i];
            if (!(resource instanceof AggregatedResource)) continue;
            AggregatedResource aggregatedResource = (AggregatedResource)((Object)resource);
            resourceArray[i] = aggregatedResource.apply(mergeStrategy);
            bl |= resourceArray[i] != aggregatedResource;
        }
        return bl ? new GroupAggregate(this, resourceArray) : this;
    }

    final <E extends Group<?>> void fillWithChildAggregates(Group<E> group, BiConsumer<E, GroupAggregate> biConsumer) {
        assert (this.components.length == group.members.size());
        for (int i = 0; i < this.components.length; ++i) {
            Group group2 = (Group)group.members.get(i);
            GroupAggregate groupAggregate = group2.prepareAggregate(this.listeners);
            biConsumer.accept(group2, groupAggregate);
            this.components[i] = groupAggregate;
        }
    }

    final void fillWithCoverageComponents(List<GroupByTransform> list, List<SampleDimension> list2) {
        this.componentsAreLeaves = true;
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = list.get(i).createResource(this.listeners, list2);
        }
    }

    final Resource simplify(CoverageAggregator coverageAggregator) {
        if (!this.componentsAreLeaves) {
            for (int i = 0; i < this.components.length; ++i) {
                Resource resource = this.components[i];
                if (!(resource instanceof GroupAggregate)) continue;
                this.components[i] = ((GroupAggregate)resource).simplify(coverageAggregator);
            }
        }
        if (this.components.length == 1) {
            Resource resource = this.components[0];
            if (resource instanceof AggregatedResource) {
                ((AggregatedResource)((Object)resource)).setName(this.name);
            }
            return resource;
        }
        return coverageAggregator.existingAggregate(this.components).orElse(this);
    }

    public Collection<Resource> components() {
        return UnmodifiableArrayList.wrap(this.components);
    }

    @Override
    public synchronized Optional<Envelope> getEnvelope() throws DataStoreException {
        if (!this.envelopeIsEvaluated) {
            try {
                this.envelope = GroupAggregate.unionOfComponents(this.components);
            }
            catch (TransformException transformException) {
                this.listeners.warning(transformException);
            }
            this.envelopeIsEvaluated = true;
        }
        return Optional.ofNullable(this.envelope);
    }

    static ImmutableEnvelope unionOfComponents(Resource[] resourceArray) throws DataStoreException, TransformException {
        Envelope[] envelopeArray = new Envelope[resourceArray.length];
        for (int i = 0; i < resourceArray.length; ++i) {
            Resource resource = resourceArray[i];
            if (resource instanceof AbstractResource) {
                envelopeArray[i] = ((AbstractResource)resource).getEnvelope().orElse(null);
                continue;
            }
            if (!(resource instanceof GridCoverageResource)) continue;
            envelopeArray[i] = ((GridCoverageResource)resource).getEnvelope().orElse(null);
        }
        return ImmutableEnvelope.castOrCopy(Envelopes.union(envelopeArray));
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        metadataBuilder.addTitle(this.name);
        try {
            metadataBuilder.addExtent(this.envelope);
        }
        catch (TransformException transformException) {
            this.listeners.warning(transformException);
        }
        if (this.sampleDimensions != null) {
            for (SampleDimension sampleDimension : this.sampleDimensions) {
                metadataBuilder.addNewBand(sampleDimension);
            }
        }
        return metadataBuilder.build();
    }

    public String toString() {
        return Strings.toString(this.getClass(), "name", this.name, "size", this.components.length);
    }
}

