/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.regex.Pattern;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class Mollweide
extends NormalizedProjection {
    private static final long serialVersionUID = 712275000459795291L;

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.Mollweide.CENTRAL_MERIDIAN);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.Mollweide.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.Mollweide.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, Variant.SPHERICAL);
    }

    public Mollweide(OperationMethod method, Parameters parameters) {
        super(Mollweide.initializer(method, parameters), null);
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        normalize.convertAfter(0, 2.8284271247461903, null);
        denormalize.convertBefore(0, 0.3183098861837907, null);
        denormalize.convertBefore(1, 1.4142135623730951, null);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        double \u03b8p = 2.0 * Math.asin(\u03c6 * 0.6366197723675814);
        if (Math.abs(sin\u03c6) != 1.0) {
            double \u0394\u03b8;
            double \u03c0sin\u03c6 = Math.PI * sin\u03c6;
            int nbIter = 18;
            do {
                if (--nbIter < 0) {
                    throw new ProjectionException(Resources.format((short)46));
                }
                \u0394\u03b8 = (\u03b8p + Math.sin(\u03b8p) - \u03c0sin\u03c6) / (1.0 + Math.cos(\u03b8p));
                \u03b8p -= \u0394\u03b8;
            } while (Math.abs(\u0394\u03b8) > 7.853353365705227E-10);
        }
        double \u03b8 = \u03b8p * 0.5;
        double x = Math.cos(\u03b8) * \u03bb;
        double y = Math.sin(\u03b8);
        if (dstPts != null) {
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
        }
        if (!derivate) {
            return null;
        }
        try {
            return Matrices.inverse(Mollweide.inverseDerivate(x, y, \u03b8p, sin\u03c6));
        }
        catch (NoninvertibleMatrixException e) {
            throw new ProjectionException(e);
        }
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double \u03b8 = Math.asin(y);
        double \u03b8p = 2.0 * \u03b8;
        double \u03c6 = Math.asin((\u03b8p + Math.sin(\u03b8p)) * 0.3183098861837907);
        double \u03bb = x / Math.cos(\u03b8);
        if (Math.abs(\u03bb) > 8.885765876316732) {
            \u03bb = Double.NaN;
        }
        dstPts[dstOff] = \u03bb;
        dstPts[dstOff + 1] = \u03c6;
    }

    private static Matrix inverseDerivate(double x, double y, double \u03b8p, double sin\u03c6) {
        double cos\u03c6 = Math.sqrt(1.0 - sin\u03c6 * sin\u03c6);
        double ym1 = 1.0 - y * y;
        double d\u03bb_dx = 1.0 / Math.sqrt(ym1);
        double d\u03bb_dy = x * y * d\u03bb_dx / ym1;
        double d\u03c6_dy = 2.0 * d\u03bb_dx * (1.0 + Math.cos(\u03b8p)) / (Math.PI * cos\u03c6);
        return new Matrix2(d\u03bb_dx, d\u03bb_dy, 0.0, d\u03c6_dy);
    }

    private static enum Variant implements ProjectionVariant
    {
        SPHERICAL;


        @Override
        public Pattern getOperationNamePattern() {
            return null;
        }

        @Override
        public String getIdentifier() {
            return null;
        }

        @Override
        public boolean useAuthalicRadius() {
            return true;
        }
    }
}

