/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.cert.X509CertSelector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.AbstractTriStatePredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;

public class EvaluableX509CertSelectorCredentialCriterion
extends AbstractTriStatePredicate<Credential>
implements EvaluableCredentialCriterion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableX509CertSelectorCredentialCriterion.class);
    @Nonnull
    private final X509CertSelector certSelector;

    public EvaluableX509CertSelectorCredentialCriterion(@Nonnull X509CertSelector selector) {
        this.certSelector = (X509CertSelector)Constraint.isNotNull((Object)selector, (String)"X.509 cert selector cannot be null");
    }

    @Override
    public boolean test(@Nullable Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return this.isNullInputSatisfies();
        }
        if (!(target instanceof X509Credential)) {
            this.log.info("Credential is not an X509Credential, cannot evaluate X509CertSelector criteria");
            return false;
        }
        return this.certSelector.match(((X509Credential)target).getEntityCertificate());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvaluableX509CertSelectorCredentialCriterion [certSelector=");
        builder.append("<contents not displayable>");
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.certSelector.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EvaluableX509CertSelectorCredentialCriterion) {
            EvaluableX509CertSelectorCredentialCriterion other = (EvaluableX509CertSelectorCredentialCriterion)obj;
            return this.certSelector.equals(other.certSelector);
        }
        return false;
    }
}

