/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.valueextraction.ValueExtractor;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.ConstraintCached;
import org.apache.bval.jsr.ValidatorImpl;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.DescriptorManager;
import org.apache.bval.jsr.groups.GroupsComputer;
import org.apache.bval.jsr.valueextraction.ValueExtractors;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class ApacheFactoryContext
implements ValidatorContext {
    private final ApacheValidatorFactory factory;
    private final ValueExtractors valueExtractors;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ParameterNameProvider parameterNameProvider;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private ClockProvider clockProvider;

    public ApacheFactoryContext(ApacheValidatorFactory factory) {
        this.factory = factory;
        this.valueExtractors = factory.getValueExtractors().createChild();
    }

    private synchronized void resetMeta() {
        this.getDescriptorManager().clear();
    }

    public ApacheFactoryContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
        return this;
    }

    public ApacheFactoryContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    public ApacheFactoryContext constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    public ApacheFactoryContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        this.parameterNameProvider = parameterNameProvider;
        this.resetMeta();
        return this;
    }

    public ApacheFactoryContext clockProvider(ClockProvider clockProvider) {
        this.clockProvider = clockProvider;
        return this;
    }

    public ApacheFactoryContext addValueExtractor(ValueExtractor<?> extractor) {
        this.valueExtractors.add(extractor);
        return this;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory == null ? this.factory.getConstraintValidatorFactory() : this.constraintValidatorFactory;
    }

    public Validator getValidator() {
        return new ValidatorImpl(this);
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator == null ? this.factory.getMessageInterpolator() : this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver == null ? this.factory.getTraversableResolver() : this.traversableResolver;
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.parameterNameProvider == null ? this.factory.getParameterNameProvider() : this.parameterNameProvider;
    }

    public ClockProvider getClockProvider() {
        return this.clockProvider == null ? this.factory.getClockProvider() : this.clockProvider;
    }

    public ValueExtractors getValueExtractors() {
        return this.valueExtractors;
    }

    public DescriptorManager getDescriptorManager() {
        return this.factory.getDescriptorManager();
    }

    public GroupsComputer getGroupsComputer() {
        return this.factory.getGroupsComputer();
    }

    public ConstraintCached getConstraintsCache() {
        return this.factory.getConstraintsCache();
    }

    public ApacheValidatorFactory getFactory() {
        return this.factory;
    }

    public ConstraintValidator getOrComputeConstraintValidator(ConstraintD<?> constraint, Supplier<ConstraintValidator> computer) {
        ConcurrentMap<ConstraintD<?>, ConstraintValidator<?, ?>> constraintsCache = this.factory.getConstraintsCache().getValidators();
        ConstraintValidator validator = (ConstraintValidator)constraintsCache.get(constraint);
        if (validator != null) {
            return validator;
        }
        ConstraintValidator instance = computer.get();
        ConstraintValidator existing = constraintsCache.putIfAbsent(constraint, instance);
        if (existing != null) {
            instance = existing;
        }
        return instance;
    }
}

