/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.OpTypes;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SetFunctionValueAggregate;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.List;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionAggregate
extends Expression {
    Expression condition = Expression.EXPR_TRUE;

    ExpressionAggregate(int n, boolean bl, Expression expression) {
        super(n);
        this.nodes = new Expression[]{expression};
        this.isDistinctAggregate = bl;
        if (!OpTypes.aggregateFunctionSet.contains(this.opType)) {
            throw Error.runtimeError(201, "ExpressionAggregate");
        }
    }

    @Override
    public boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = ExpressionAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 108: {
                stringBuilder.append(' ').append("ANY_VALUE").append('(').append(string).append(')');
                break;
            }
            case 74: {
                stringBuilder.append(' ').append("COUNT").append('(').append(string).append(')');
                break;
            }
            case 75: {
                stringBuilder.append(' ').append("SUM").append('(').append(string).append(')');
                break;
            }
            case 76: {
                stringBuilder.append(' ').append("MIN").append('(').append(string).append(')');
                break;
            }
            case 77: {
                stringBuilder.append(' ').append("MAX").append('(').append(string).append(')');
                break;
            }
            case 78: {
                stringBuilder.append(' ').append("AVG").append('(').append(string).append(')');
                break;
            }
            case 79: {
                stringBuilder.append(' ').append("EVERY").append('(').append(string).append(')');
                break;
            }
            case 80: {
                stringBuilder.append(' ').append("SOME").append('(').append(string).append(')');
                break;
            }
            case 81: {
                stringBuilder.append(' ').append("STDDEV_POP").append('(').append(string).append(')');
                break;
            }
            case 82: {
                stringBuilder.append(' ').append("STDDEV_SAMP").append('(').append(string).append(')');
                break;
            }
            case 83: {
                stringBuilder.append(' ').append("VAR_POP").append('(').append(string).append(')');
                break;
            }
            case 84: {
                stringBuilder.append(' ').append("VAR_SAMP").append('(').append(string).append(')');
                break;
            }
            case 106: {
                stringBuilder.append(' ').append("STDDEV").append('(').append(string).append(')');
                break;
            }
            case 107: {
                stringBuilder.append(' ').append("VARIANCE").append('(').append(string).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 108: {
                stringBuilder.append("ANY_VALUE").append(' ');
                break;
            }
            case 74: {
                stringBuilder.append("COUNT").append(' ');
                break;
            }
            case 75: {
                stringBuilder.append("SUM").append(' ');
                break;
            }
            case 76: {
                stringBuilder.append("MIN").append(' ');
                break;
            }
            case 77: {
                stringBuilder.append("MAX").append(' ');
                break;
            }
            case 78: {
                stringBuilder.append("AVG").append(' ');
                break;
            }
            case 79: {
                stringBuilder.append("EVERY").append(' ');
                break;
            }
            case 80: {
                stringBuilder.append("SOME").append(' ');
                break;
            }
            case 81: {
                stringBuilder.append("STDDEV_POP").append(' ');
                break;
            }
            case 82: {
                stringBuilder.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 83: {
                stringBuilder.append("VAR_POP").append(' ');
                break;
            }
            case 84: {
                stringBuilder.append("VAR_SAMP").append(' ');
                break;
            }
            case 106: {
                stringBuilder.append("STDDEV").append(' ');
                break;
            }
            case 107: {
                stringBuilder.append("VARIANCE").append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            stringBuilder.append(" arg=[");
            stringBuilder.append(this.nodes[0].describe(session, n + 1));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public List<Expression> resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, List<Expression> list, boolean bl) {
        List<Expression> list2 = this.condition.resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, null, false);
        ExpressionColumn.checkColumnsResolved(list2);
        if (list == null) {
            list = new ArrayListIdentity<Expression>();
        }
        list.add(this);
        if (rangeGroup.getRangeVariables().length > 0) {
            this.rangeGroups = rangeGroupArray;
            this.rangeGroup = rangeGroup;
        }
        return list;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].getDegree() > 1) {
            this.nodes[0].dataType = new RowType(this.nodes[0].nodeDataTypes);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.isDistinctAggregate && this.nodes[0].dataType.isLobType()) {
            throw Error.error(5534);
        }
        this.dataType = ExpressionAggregate.getType(session, this.opType, this.nodes[0].dataType);
    }

    static Type getType(Session session, int n, Type type) {
        if (n == 74) {
            return Type.SQL_BIGINT;
        }
        int n2 = type.typeCode;
        if (type.isIntervalYearMonthType()) {
            n2 = 102;
        } else if (type.isIntervalDaySecondType()) {
            n2 = 106;
        }
        switch (n) {
            case 78: 
            case 89: {
                switch (n2) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 25: {
                        int n3 = session.database.sqlAvgScale;
                        if (n3 <= type.scale) {
                            return type;
                        }
                        int n4 = ((NumberType)type).getDecimalPrecision();
                        return NumberType.getNumberType(3, n4 + n3, n3);
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 102: 
                    case 106: {
                        return type;
                    }
                }
                throw Error.error(5563);
            }
            case 75: {
                switch (n2) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return Type.SQL_BIGINT;
                    }
                    case 25: {
                        return Type.SQL_DECIMAL_BIGINT_SQR;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return Type.SQL_DOUBLE;
                    }
                    case 2: 
                    case 3: {
                        return Type.getType(type.typeCode, null, null, type.precision * 2L, type.scale);
                    }
                    case 102: 
                    case 106: {
                        return IntervalType.newIntervalType(type.typeCode, 9L, type.scale);
                    }
                }
                throw Error.error(5563);
            }
            case 76: 
            case 77: 
            case 108: {
                if (type.isArrayType() || type.isLobType()) {
                    throw Error.error(5563);
                }
                return type;
            }
            case 79: 
            case 80: {
                if (!type.isBooleanType()) break;
                return Type.SQL_BOOLEAN;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 106: 
            case 107: {
                if (!type.isNumberType()) break;
                return Type.SQL_DOUBLE;
            }
            case 100: {
                return type;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        throw Error.error(5563);
    }

    @Override
    boolean equals(Expression expression) {
        if (expression instanceof ExpressionAggregate) {
            ExpressionAggregate expressionAggregate = (ExpressionAggregate)expression;
            boolean bl = super.equals(expressionAggregate) && this.condition.equals(expressionAggregate.condition) && this.isDistinctAggregate == expressionAggregate.isDistinctAggregate;
            return bl;
        }
        return false;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction) {
        if (!this.condition.testCondition(session)) {
            return setFunction;
        }
        if (setFunction == null) {
            setFunction = this.getSetFunction(session);
        }
        Integer n = this.nodes[0].opType == 11 ? ValuePool.INTEGER_1 : this.nodes[0].getValue(session);
        setFunction.add(n);
        return setFunction;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction, SetFunction setFunction2) {
        if (setFunction == null) {
            setFunction = this.getSetFunction(session);
        }
        setFunction.addGroup(setFunction2);
        return setFunction;
    }

    SetFunction getSetFunction(Session session) {
        return new SetFunctionValueAggregate(session, this.opType, this.nodes[0].dataType, this.dataType, this.isDistinctAggregate);
    }

    @Override
    public Object getAggregatedValue(Session session, SetFunction setFunction) {
        if (setFunction == null) {
            return this.opType == 74 ? Long.valueOf(0L) : null;
        }
        return setFunction.getValue();
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return !this.condition.isTrue();
    }

    @Override
    public void setCondition(Expression expression) {
        this.condition = expression;
    }
}

