/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.adapter;

import jakarta.json.bind.annotation.JsonbProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.MapperConfig;

public class JsonbEnumAdapter<T extends Enum<T>>
implements MapperConfig.CustomEnumConverter<T> {
    private final Map<String, T> values;
    private final Map<T, String> reversed;
    private final Class<T> enumType;

    public JsonbEnumAdapter(Class<T> aClass) {
        this.enumType = aClass;
        Enum[] enumConstants = aClass.isEnum() ? (Enum[])aClass.getEnumConstants() : (Enum[])aClass.getSuperclass().getEnumConstants();
        this.values = new HashMap<String, T>(enumConstants.length);
        this.reversed = new HashMap<T, String>(enumConstants.length);
        for (Enum t : enumConstants) {
            try {
                Field field = this.findField(aClass, t.name());
                JsonbProperty property = field.getAnnotation(JsonbProperty.class);
                String name = property == null || property.value().isEmpty() ? t.name() : property.value();
                this.values.put(name, t);
                this.reversed.put(t, name);
            }
            catch (Exception e) {
                this.values.put(t.name(), t);
                this.reversed.put(t, t.name());
            }
        }
    }

    public String toString(T instance) {
        return instance != null ? this.reversed.get(instance) : null;
    }

    public T fromString(String text) {
        Enum val = (Enum)this.values.get(text);
        if (val == null) {
            throw new IllegalArgumentException("Illegal " + String.valueOf(this.enumType) + " enum value: " + text + ", known values: " + String.valueOf(this.values.keySet()));
        }
        return (T)val;
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.values.keySet());
    }

    public Type type() {
        return this.enumType;
    }

    private Field findField(Class<T> impl, String field) {
        for (Class<T> type = impl; type != null && type != Object.class && type != Enum.class; type = type.getSuperclass()) {
            try {
                return type.getDeclaredField(field);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Missing field: " + field);
    }
}

