/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.polymorphism;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.JsonbException;
import jakarta.json.bind.annotation.JsonbTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.johnzon.jsonb.polymorphism.JsonbPolymorphismTypeInfo;
import org.apache.johnzon.mapper.access.Meta;

public class JsonbPolymorphismHandler {
    private final Map<Class<?>, JsonbPolymorphismTypeInfo> typeInfoCache = new HashMap();

    public boolean hasPolymorphism(Class<?> clazz) {
        return this.getOrCreatePolymorphismTypeInfo(clazz) != null;
    }

    public Map.Entry<String, String>[] getPolymorphismPropertiesToSerialize(Class<?> clazz, Collection<String> otherProperties) {
        ArrayList<Map.Entry<String, Object>> result = new ArrayList<Map.Entry<String, Object>>();
        for (JsonbPolymorphismTypeInfo polymorphismTypeInfo = this.getOrCreatePolymorphismTypeInfo(clazz); polymorphismTypeInfo != null; polymorphismTypeInfo = polymorphismTypeInfo.getFirstParent()) {
            if (!polymorphismTypeInfo.hasSubtypeInformation()) continue;
            if (otherProperties.contains(polymorphismTypeInfo.getTypeKey())) {
                throw new JsonbException("JsonbTypeInfo key '" + polymorphismTypeInfo.getTypeKey() + "' collides with other properties in json");
            }
            String bestMatchingAlias = null;
            for (Map.Entry<String, Class<?>> aliasToType : polymorphismTypeInfo.getAliases().entrySet()) {
                String alias = aliasToType.getKey();
                Class<?> type = aliasToType.getValue();
                if (!type.isAssignableFrom(clazz)) continue;
                bestMatchingAlias = alias;
                if (clazz != type) continue;
                break;
            }
            if (bestMatchingAlias == null) continue;
            result.add(0, Map.entry(polymorphismTypeInfo.getTypeKey(), bestMatchingAlias));
        }
        return (Map.Entry[])result.toArray(Map.Entry[]::new);
    }

    public Class<?> getTypeToDeserialize(JsonObject jsonObject, Class<?> clazz) {
        JsonbPolymorphismTypeInfo typeInfo = this.getOrCreatePolymorphismTypeInfo(clazz);
        if (typeInfo == null) {
            return clazz;
        }
        JsonValue typeValue = (JsonValue)jsonObject.get((Object)typeInfo.getTypeKey());
        if (typeValue == null) {
            return clazz;
        }
        if (typeValue.getValueType() != JsonValue.ValueType.STRING) {
            throw new JsonbException("Property '" + typeInfo.getTypeKey() + "' isn't a String, resolving JsonbSubtype is impossible");
        }
        String typeValueString = ((JsonString)typeValue).getString();
        Class<?> result = typeInfo.getAliases().get(typeValueString);
        if (result == null) {
            throw new JsonbException("No JsonbSubtype found for alias '" + typeValueString + "' on " + clazz.getName());
        }
        return result;
    }

    public JsonbPolymorphismTypeInfo getOrCreatePolymorphismTypeInfo(Class<?> clazz) {
        if (this.typeInfoCache.containsKey(clazz)) {
            return this.typeInfoCache.get(clazz);
        }
        JsonbPolymorphismTypeInfo result = null;
        JsonbTypeInfo directAnnotation = (JsonbTypeInfo)Meta.getAnnotation(clazz, JsonbTypeInfo.class);
        if (directAnnotation != null) {
            result = new JsonbPolymorphismTypeInfo(clazz, directAnnotation);
        }
        ArrayList<JsonbPolymorphismTypeInfo> parents = new ArrayList<JsonbPolymorphismTypeInfo>();
        List<Class<?>> candidates = List.of(clazz);
        while (!candidates.isEmpty() && parents.isEmpty()) {
            ArrayList candidatesNextLevel = new ArrayList();
            for (Class<?> current : candidates) {
                if (current.getSuperclass() != null) {
                    candidatesNextLevel.add(current.getSuperclass());
                    if (Meta.getAnnotation(current.getSuperclass(), JsonbTypeInfo.class) != null) {
                        parents.add(this.getOrCreatePolymorphismTypeInfo(current.getSuperclass()));
                    }
                }
                for (Class<?> iface : current.getInterfaces()) {
                    candidatesNextLevel.add(iface);
                    if (Meta.getAnnotation(iface, JsonbTypeInfo.class) == null) continue;
                    parents.add(this.getOrCreatePolymorphismTypeInfo(iface));
                }
            }
            candidates = candidatesNextLevel;
        }
        if (!parents.isEmpty()) {
            if (result == null) {
                result = new JsonbPolymorphismTypeInfo(clazz, null);
            }
            result.getParents().addAll(parents);
        }
        this.typeInfoCache.put(clazz, result);
        return result;
    }

    public void validateJsonbPolymorphismAnnotations(Class<?> classToValidate) {
        this.validateSubtypeCompatibility(classToValidate);
        this.validateOnlyOneParentWithTypeInfo(classToValidate);
        this.validateNoTypeInfoKeyCollision(classToValidate);
    }

    protected void validateSubtypeCompatibility(Class<?> classToValidate) {
        JsonbPolymorphismTypeInfo polymorphismTypeInfo = this.getOrCreatePolymorphismTypeInfo(classToValidate);
        if (polymorphismTypeInfo == null || !polymorphismTypeInfo.hasSubtypeInformation()) {
            return;
        }
        for (Map.Entry<String, Class<?>> aliasToType : polymorphismTypeInfo.getAliases().entrySet()) {
            String alias = aliasToType.getKey();
            Class<?> type = aliasToType.getValue();
            if (classToValidate.isAssignableFrom(type)) continue;
            throw new JsonbException("JsonbSubtype '" + alias + "' (" + type.getName() + ") is not a subclass of " + String.valueOf(classToValidate));
        }
    }

    protected void validateOnlyOneParentWithTypeInfo(Class<?> classToValidate) {
        JsonbPolymorphismTypeInfo polymorphismTypeInfo = this.getOrCreatePolymorphismTypeInfo(classToValidate);
        if (polymorphismTypeInfo != null && polymorphismTypeInfo.getParents().size() > 1) {
            throw new JsonbException("More than one interface/superclass of " + classToValidate.getName() + " has JsonbTypeInfo Annotation");
        }
    }

    protected void validateNoTypeInfoKeyCollision(Class<?> classToValidate) {
        HashMap keyToDefiningClass = new HashMap();
        for (JsonbPolymorphismTypeInfo current = this.getOrCreatePolymorphismTypeInfo(classToValidate); current != null; current = current.getFirstParent()) {
            Class<?> existing = keyToDefiningClass.put(current.getTypeKey(), current.getClazz());
            if (existing == null) continue;
            throw new JsonbException("JsonbTypeInfo key '" + current.getTypeKey() + "' found more than once in type hierarchy of " + String.valueOf(classToValidate) + " (first defined in " + existing.getName() + ", then defined again in " + current.getClazz().getName() + ")");
        }
    }
}

