/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.LocalConstraint;
import org.apache.openjpa.jdbc.schema.NameSet;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.ReferenceCounter;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;

public class SchemaGroup
extends NameSet
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<DBIdentifier, Schema> _schemaMap = null;
    private Schema[] _schemas = null;

    public Schema[] getSchemas() {
        if (this._schemas == null) {
            this._schemas = this._schemaMap == null ? new Schema[]{} : this._schemaMap.values().toArray(new Schema[this._schemaMap.size()]);
        }
        return this._schemas;
    }

    @Deprecated
    public Schema getSchema(String name) {
        if (this._schemaMap == null) {
            return null;
        }
        return this.getSchema(DBIdentifier.toUpper(DBIdentifier.newSchema(name)));
    }

    public Schema getSchema(DBIdentifier name) {
        if (this._schemaMap == null) {
            return null;
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        Schema schema = this._schemaMap.get(sName);
        return schema;
    }

    public Schema addSchema() {
        return this.addSchema(DBIdentifier.NULL);
    }

    public Schema addSchema(DBIdentifier name) {
        this.addName(name, false);
        Schema schema = this.newSchema(name);
        DBIdentifier sName = DBIdentifier.toUpper(name);
        if (this._schemaMap == null) {
            this._schemaMap = new HashMap<DBIdentifier, Schema>();
        }
        this._schemaMap.put(sName, schema);
        this._schemas = null;
        return schema;
    }

    @Deprecated
    public Schema addSchema(String name) {
        return this.addSchema(DBIdentifier.newSchema(name));
    }

    public boolean removeSchema(Schema schema) {
        if (schema == null) {
            return false;
        }
        DBIdentifier name = DBIdentifier.toUpper(schema.getIdentifier());
        Schema rem = this._schemaMap.get(name);
        if (schema.equals(rem)) {
            this._schemaMap.remove(name);
            this.removeName(schema.getIdentifier());
            this._schemas = null;
            schema.remove();
            return true;
        }
        return false;
    }

    public Schema importSchema(Schema schema) {
        Table[] tables;
        Sequence[] seqs;
        if (schema == null) {
            return null;
        }
        Schema copy = this.addSchema(schema.getIdentifier());
        for (Sequence seq : seqs = schema.getSequences()) {
            copy.importSequence(seq);
        }
        for (Table table : tables = schema.getTables()) {
            Table tab = copy.importTable(table);
            Index[] idxs = table.getIndexes();
            for (Index index : idxs) {
                tab.importIndex(index);
            }
            Unique[] unqs = table.getUniques();
            for (LocalConstraint localConstraint : unqs) {
                tab.importUnique((Unique)localConstraint);
            }
        }
        return copy;
    }

    public boolean isKnownTable(Table table) {
        return this.findTable(table) != null;
    }

    @Deprecated
    public boolean isKnownTable(String name) {
        return this.findTable(name) != null;
    }

    public boolean isKnownTable(QualifiedDBIdentifier path) {
        return this.findTable(path) != null;
    }

    public Table findTable(Table table) {
        return this.findTable(table.getQualifiedPath());
    }

    @Deprecated
    public Table findTable(String name) {
        if (name == null) {
            return null;
        }
        return this.findTable(QualifiedDBIdentifier.getPath(DBIdentifier.newTable(name)));
    }

    public Table findTable(QualifiedDBIdentifier path) {
        if (DBIdentifier.isNull(path)) {
            return null;
        }
        if (!DBIdentifier.isNull(path.getSchemaName())) {
            Schema schema = this.getSchema(path.getSchemaName());
            if (schema != null) {
                return schema.getTable(path.getUnqualifiedName());
            }
        } else {
            Schema[] schemas;
            for (Schema schema : schemas = this.getSchemas()) {
                Table tab = schema.getTable(path.getIdentifier());
                if (tab == null) continue;
                return tab;
            }
        }
        return null;
    }

    @Deprecated
    public Table findTable(Schema inSchema, String name) {
        if (name == null) {
            return null;
        }
        return this.findTable(inSchema, DBIdentifier.newTable(name), DBIdentifier.NULL);
    }

    public Table findTable(Schema inSchema, DBIdentifier name) {
        if (DBIdentifier.isNull(name)) {
            return null;
        }
        return this.findTable(inSchema, QualifiedDBIdentifier.getPath(name), DBIdentifier.NULL);
    }

    public Table findTable(Schema inSchema, DBIdentifier name, DBIdentifier defaultSchemaName) {
        if (DBIdentifier.isNull(name)) {
            return null;
        }
        return this.findTable(inSchema, QualifiedDBIdentifier.getPath(name), defaultSchemaName);
    }

    public Table findTable(Schema inSchema, QualifiedDBIdentifier path, DBIdentifier defaultSchemaName) {
        if (path == null) {
            return null;
        }
        if (!DBIdentifier.isNull(path.getSchemaName())) {
            Schema schema = this.getSchema(path.getSchemaName());
            if (schema != null) {
                return schema.getTable(path.getIdentifier());
            }
        } else {
            Schema[] schemas;
            for (Schema schema : schemas = this.getSchemas()) {
                boolean hasNoDefaultSchema;
                Table tab = schema.getTable(path.getIdentifier());
                boolean isDefaultSchema = DBIdentifier.isNull(inSchema.getIdentifier()) && !DBIdentifier.isNull(defaultSchemaName) && DBIdentifier.equalsIgnoreCase(defaultSchemaName, schema.getIdentifier());
                boolean bl = hasNoDefaultSchema = DBIdentifier.isNull(inSchema.getIdentifier()) && DBIdentifier.isNull(defaultSchemaName);
                if (tab == null || schema != inSchema && !isDefaultSchema && !hasNoDefaultSchema) continue;
                return tab;
            }
        }
        return null;
    }

    public boolean isKnownSequence(Sequence seq) {
        return this.findSequence(seq) != null;
    }

    @Deprecated
    public boolean isKnownSequence(String name) {
        return this.findSequence(name) != null;
    }

    public boolean isKnownSequence(DBIdentifier name) {
        return this.findSequence(QualifiedDBIdentifier.getPath(name)) != null;
    }

    public boolean isKnownSequence(QualifiedDBIdentifier path) {
        return this.findSequence(path) != null;
    }

    public Sequence findSequence(Sequence seq) {
        return this.findSequence(seq.getQualifiedPath());
    }

    @Deprecated
    public Sequence findSequence(String name) {
        if (name == null) {
            return null;
        }
        return this.findSequence(DBIdentifier.newSequence(name));
    }

    public Sequence findSequence(DBIdentifier name) {
        if (DBIdentifier.isNull(name)) {
            return null;
        }
        return this.findSequence(QualifiedDBIdentifier.getPath(name));
    }

    public Sequence findSequence(QualifiedDBIdentifier path) {
        if (path == null) {
            return null;
        }
        if (!DBIdentifier.isNull(path.getSchemaName())) {
            Schema schema = this.getSchema(path.getSchemaName());
            if (schema != null) {
                return schema.getSequence(path.getIdentifier());
            }
        } else {
            Schema[] schemas;
            for (Schema schema : schemas = this.getSchemas()) {
                Sequence seq = schema.getSequence(path.getIdentifier());
                if (seq == null) continue;
                return seq;
            }
        }
        return null;
    }

    @Deprecated
    public Sequence findSequence(Schema inSchema, String name) {
        if (name == null) {
            return null;
        }
        return this.findSequence(inSchema, QualifiedDBIdentifier.getPath(DBIdentifier.newSequence(name)));
    }

    public Sequence findSequence(Schema inSchema, QualifiedDBIdentifier path) {
        if (path == null) {
            return null;
        }
        if (!DBIdentifier.isNull(path.getSchemaName())) {
            Schema schema = this.getSchema(path.getSchemaName());
            if (schema != null) {
                return schema.getSequence(path.getIdentifier());
            }
        } else {
            Schema[] schemas;
            for (Schema schema : schemas = this.getSchemas()) {
                Sequence seq = schema.getSequence(path.getIdentifier());
                if (seq == null || schema != inSchema && !DBIdentifier.isNull(inSchema.getIdentifier())) continue;
                return seq;
            }
        }
        return null;
    }

    public ForeignKey[] findExportedForeignKeys(PrimaryKey pk) {
        if (pk == null) {
            return new ForeignKey[0];
        }
        Schema[] schemas = this.getSchemas();
        LinkedList<ForeignKey> exports = new LinkedList<ForeignKey>();
        for (Schema schema : schemas) {
            Table[] tabs;
            for (Table tab : tabs = schema.getTables()) {
                ForeignKey[] fks;
                for (ForeignKey fk : fks = tab.getForeignKeys()) {
                    if (fk.getPrimaryKeyTable() == null || !pk.equals(fk.getPrimaryKeyTable().getPrimaryKey())) continue;
                    exports.add(fk);
                }
            }
        }
        return exports.toArray(new ForeignKey[exports.size()]);
    }

    public void removeUnusedComponents() {
        Schema[] schemas;
        for (Schema schema : schemas = this.getSchemas()) {
            Sequence[] seqs = schema.getSequences();
            for (Sequence sequence : seqs) {
                if (sequence.getRefCount() != 0) continue;
                schema.removeSequence(sequence);
            }
            Table[] tabs = schema.getTables();
            for (Comparable<Sequence> comparable : tabs) {
                PrimaryKey pk = ((Table)comparable).getPrimaryKey();
                ForeignKey[] fks = ((Table)comparable).getForeignKeys();
                Column[] cols = ((Table)comparable).getColumns();
                if (pk != null && pk.getRefCount() == 0) {
                    ((Table)comparable).removePrimaryKey();
                }
                for (ForeignKey foreignKey : fks) {
                    if (foreignKey.getRefCount() != 0) continue;
                    ((Table)comparable).removeForeignKey(foreignKey);
                }
                for (ReferenceCounter referenceCounter : cols) {
                    if (((Column)referenceCounter).getRefCount() != 0) continue;
                    ((Table)comparable).removeColumn((Column)referenceCounter);
                }
                if (((Table)comparable).getColumns().length != 0) continue;
                schema.removeTable((Table)comparable);
            }
            if (schema.getTables().length != 0) continue;
            this.removeSchema(schema);
        }
    }

    public Object clone() {
        SchemaGroup clone = this.newInstance();
        clone.copy(this);
        return clone;
    }

    protected SchemaGroup newInstance() {
        return new SchemaGroup();
    }

    protected void copy(SchemaGroup group) {
        Schema[] schemas;
        for (Schema value : schemas = group.getSchemas()) {
            this.importSchema(value);
        }
        for (Schema schema : schemas) {
            Table[] tabs;
            for (Table tab : tabs = schema.getTables()) {
                ForeignKey[] fks;
                for (ForeignKey fk : fks = tab.getForeignKeys()) {
                    this.getSchema(schema.getIdentifier()).getTable(tab.getIdentifier()).importForeignKey(fk);
                }
            }
        }
    }

    @Deprecated
    protected Schema newSchema(String name) {
        return new Schema(name, this);
    }

    protected Schema newSchema(DBIdentifier name) {
        return new Schema(name, this);
    }

    @Deprecated
    protected Sequence newSequence(String name, Schema schema) {
        return new Sequence(name, schema);
    }

    protected Sequence newSequence(DBIdentifier name, Schema schema) {
        return new Sequence(name, schema);
    }

    @Deprecated
    protected Table newTable(String name, Schema schema) {
        return new Table(name, schema);
    }

    protected Table newTable(DBIdentifier name, Schema schema) {
        return new Table(name, schema);
    }

    @Deprecated
    protected Column newColumn(String name, Table table) {
        return new Column(name, table);
    }

    protected Column newColumn(DBIdentifier name, Table table) {
        return new Column(name, table);
    }

    @Deprecated
    protected PrimaryKey newPrimaryKey(String name, Table table) {
        return new PrimaryKey(name, table);
    }

    protected PrimaryKey newPrimaryKey(DBIdentifier name, Table table) {
        return new PrimaryKey(name, table);
    }

    @Deprecated
    protected Index newIndex(String name, Table table) {
        return new Index(name, table);
    }

    protected Index newIndex(DBIdentifier name, Table table) {
        return new Index(name, table);
    }

    @Deprecated
    protected Unique newUnique(String name, Table table) {
        return new Unique(name, table);
    }

    protected Unique newUnique(DBIdentifier name, Table table) {
        return new Unique(name, table);
    }

    @Deprecated
    protected ForeignKey newForeignKey(String name, Table table) {
        return new ForeignKey(name, table);
    }

    protected ForeignKey newForeignKey(DBIdentifier name, Table table) {
        return new ForeignKey(name, table);
    }
}

