/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.List;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.torque.om.TorqueTurbinePermission;
import org.apache.fulcrum.security.torque.om.TorqueTurbinePermissionPeer;
import org.apache.fulcrum.security.torque.peer.TorqueTurbinePeer;
import org.apache.fulcrum.security.torque.peer.managers.PeerPermissionManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;

public class TorqueTurbinePermissionManagerImpl
extends PeerPermissionManager {
    private static final long serialVersionUID = 1L;

    @Override
    protected <T extends Permission> List<T> doSelectAllPermissions(Connection con) throws TorqueException {
        Criteria criteria = new Criteria();
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                return peerInstance.doSelect(criteria, con);
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        }
        return TorqueTurbinePermissionPeer.doSelect(criteria, con);
    }

    @Override
    protected <T extends Permission> T doSelectById(Integer id, Connection con) throws NoRowsException, TooManyRowsException, TorqueException {
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                return (T)((Permission)peerInstance.retrieveByPK(id, con));
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        }
        return (T)TorqueTurbinePermissionPeer.retrieveByPK(id, con);
    }

    @Override
    protected <T extends Permission> T doSelectByName(String name, Connection con) throws NoRowsException, TooManyRowsException, TorqueException {
        Criteria criteria = new Criteria();
        criteria.setIgnoreCase(true);
        criteria.setSingleRecord(true);
        List<TorqueTurbinePermission> permissions = null;
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                criteria.where((Object)peerInstance.getTableMap().getColumn(this.getColumnName()), (Object)name);
                permissions = peerInstance.doSelect(criteria, con);
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        } else {
            criteria.where((Object)TorqueTurbinePermissionPeer.PERMISSION_NAME, (Object)name);
            permissions = TorqueTurbinePermissionPeer.doSelect(criteria, con);
        }
        if (permissions.isEmpty()) {
            throw new NoRowsException(name);
        }
        return (T)((Permission)permissions.get(0));
    }
}

