/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.utils.twl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.apache.uima.ruta.resource.TreeWordList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class TWLConverterHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPreferenceStore preferenceStore = RutaIdeUIPlugin.getDefault().getPreferenceStore();
        boolean compress = preferenceStore.getBoolean("CompressWordLists");
        boolean dictRemoveWS = preferenceStore.getBoolean("dictRemoveWS");
        new ConverterHandlerJob(event, compress, dictRemoveWS).schedule();
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    private class ConverterHandlerJob
    extends Job {
        ExecutionEvent event;
        private boolean compress;
        private boolean dictRemoveWS;

        ConverterHandlerJob(ExecutionEvent event, boolean compress, boolean dictRemoveWS) {
            super("Converting...");
            this.event = event;
            this.compress = compress;
            this.dictRemoveWS = dictRemoveWS;
            this.setUser(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Collecting files...", 1);
            ArrayList<IFile> files = new ArrayList<IFile>();
            if (HandlerUtil.getCurrentSelection((ExecutionEvent)this.event) instanceof IStructuredSelection) {
                StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
                for (Object object : selection) {
                    if (!(object instanceof IFile)) continue;
                    IFile file = (IFile)object;
                    files.add(file);
                }
            }
            monitor.beginTask("Converting files...", files.size());
            for (IFile file : files) {
                TreeWordList list;
                monitor.setTaskName("Compiling " + file.getLocation().lastSegment() + "...");
                String path = file.getRawLocation().toString();
                try {
                    list = new TreeWordList(path, this.dictRemoveWS);
                }
                catch (IOException e) {
                    RutaAddonsPlugin.error(e);
                    return Status.CANCEL_STATUS;
                }
                String exportPath = path.substring(0, path.length() - 3) + "twl";
                try {
                    list.createTWLFile(exportPath, this.compress, "UTF-8");
                }
                catch (IOException e) {
                    RutaAddonsPlugin.error(e);
                }
                IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IContainer container = myWorkspaceRoot.getContainerForLocation(file.getLocation());
                if (container != null) {
                    try {
                        container.getParent().refreshLocal(1, null);
                    }
                    catch (CoreException e) {
                        RutaAddonsPlugin.error(e);
                    }
                }
                monitor.worked(1);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

