/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.utils.apply;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.ide.RutaIdePlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplyScriptHandlerJob
extends Job {
    private ExecutionEvent event;
    private IFile scriptFile;
    private boolean createXMI;

    AbstractApplyScriptHandlerJob(ExecutionEvent event, IFile scriptFile, boolean createXMI) {
        super("Applying " + scriptFile.getName() + "...");
        this.event = event;
        this.scriptFile = scriptFile;
        this.createXMI = createXMI;
        this.setUser(true);
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Collecting files...", 1);
        if (HandlerUtil.getCurrentSelection((ExecutionEvent)this.event) instanceof IStructuredSelection) {
            StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
            Iterator iter = selection.iterator();
            IResource first = null;
            ArrayList<IPath> paths = new ArrayList<IPath>();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof IResource)) continue;
                IResource resource = (IResource)object;
                if (first == null) {
                    first = resource;
                }
                paths.addAll(this.getPaths(resource));
            }
            IPath descriptorPath = RutaProjectUtils.getEngineDescriptorPath((IPath)this.scriptFile.getLocation(), (IProject)this.scriptFile.getProject());
            IPath rootPath = RutaProjectUtils.getDescriptorRootPath((IProject)this.scriptFile.getProject());
            CAS cas = null;
            AnalysisEngine ae = null;
            try {
                XMLInputSource in = new XMLInputSource(descriptorPath.toPortableString());
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
                ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
                resMgr.setDataPath(rootPath.toPortableString());
                ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier, (ResourceManager)resMgr, null);
                this.initAE(ae);
                ae.reconfigure();
            }
            catch (Exception e) {
                DLTKCore.error((String)e.getMessage(), (Throwable)e);
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask("Processing... ", paths.size());
            for (IPath path : paths) {
                if (monitor.isCanceled()) break;
                monitor.setTaskName("Processing " + path.lastSegment() + "... ");
                try {
                    if (cas == null) {
                        cas = ae.newCAS();
                    } else {
                        cas.reset();
                    }
                    if (path.getFileExtension().equals("xmi")) {
                        XmiCasDeserializer.deserialize((InputStream)new FileInputStream(path.toPortableString()), (CAS)cas, (boolean)true);
                    } else {
                        cas.setDocumentText(AbstractApplyScriptHandlerJob.getText(path.toPortableString()));
                    }
                    RutaEngine.removeSourceDocumentInformation((CAS)cas);
                    RutaEngine.addSourceDocumentInformation((CAS)cas, (File)new File(path.toPortableString()));
                    ae.process(cas);
                }
                catch (Exception e) {
                    DLTKCore.error((String)e.getMessage(), (Throwable)e);
                    monitor.worked(1);
                    continue;
                }
                if (this.createXMI) {
                    monitor.setTaskName("Writing " + path.lastSegment() + "... ");
                    File newFile = null;
                    newFile = path.getFileExtension().equals("xmi") ? new File(path.toPortableString()) : new File(path.toPortableString() + ".xmi");
                    try {
                        AbstractApplyScriptHandlerJob.writeXmi(cas, newFile);
                    }
                    catch (Exception e) {
                        DLTKCore.error((String)e.getMessage(), (Throwable)e);
                        monitor.worked(1);
                        continue;
                    }
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceRoot root = workspace.getRoot();
                    IPath makeRelativeTo = path.makeRelativeTo(root.getLocation());
                    IResource resource = root.findMember(makeRelativeTo);
                    try {
                        if (resource != null) {
                            resource.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                }
                monitor.worked(1);
            }
            if (cas != null) {
                cas.release();
            }
            if (ae != null) {
                ae.destroy();
            }
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXmi(CAS aCas, File name) throws IOException, SAXException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
        catch (Exception e) {
            RutaIdePlugin.error((Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private List<IPath> getPaths(IResource resource) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            String fileExtension = file.getFileExtension();
            if ("txt".equals(fileExtension) || "html".equals(fileExtension) || "xmi".equals(fileExtension) || "htm".equals(fileExtension)) {
                paths.add(file.getLocation());
            }
        } else if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            try {
                IResource[] members;
                for (IResource each : members = folder.members()) {
                    paths.addAll(this.getPaths(each));
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return paths;
    }

    abstract void initAE(AnalysisEngine var1);

    private static String getText(String each) {
        try {
            return FileUtils.file2String((File)new File(each), (String)"UTF-8");
        }
        catch (IOException e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

