/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerSlotPattern;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRulerMultiSlotRule
extends TextRulerRule {
    protected List<TextRulerSlotPattern> slotPatterns = new ArrayList<TextRulerSlotPattern>();

    public TextRulerMultiSlotRule(TextRulerMultiSlotRule copyFrom) {
        super(copyFrom);
        for (TextRulerSlotPattern origP : copyFrom.slotPatterns) {
            this.slotPatterns.add(origP.copy());
        }
    }

    public String getMarkName(int slotIndex) {
        return TextRulerToolkit.getTypeShortName(this.target.getMultiSlotTypeName(slotIndex));
    }

    public TextRulerMultiSlotRule(TextRulerBasicLearner parentAlgorithm, TextRulerTarget target) {
        super(parentAlgorithm, target);
    }

    protected String getInterslotWildCard() {
        return "ALL*? ";
    }

    @Override
    public void compileRuleString() {
        String ruleString = "";
        int totalSize = 0;
        int totalIndex = 0;
        int interSlotWildcards = this.slotPatterns.size() - 1;
        if (interSlotWildcards < 0) {
            interSlotWildcards = 0;
        }
        for (TextRulerSlotPattern sp : this.slotPatterns) {
            totalSize += sp.preFillerPattern.size();
            totalSize += sp.fillerPattern.size();
            totalSize += sp.postFillerPattern.size();
        }
        totalSize += interSlotWildcards;
        for (int slotIndex = 0; slotIndex < this.slotPatterns.size(); ++slotIndex) {
            TextRulerSlotPattern sPattern = this.slotPatterns.get(slotIndex);
            int index = 0;
            for (TextRulerRuleItem item : sPattern.preFillerPattern) {
                ruleString = ruleString + item.getStringForRuleString(this, TextRulerRuleItem.MLRuleItemType.PREFILLER, index, sPattern.preFillerPattern.size(), totalIndex, totalSize, slotIndex) + " ";
                ++index;
                ++totalIndex;
            }
            index = 0;
            for (TextRulerRuleItem item : sPattern.fillerPattern) {
                ruleString = ruleString + item.getStringForRuleString(this, TextRulerRuleItem.MLRuleItemType.FILLER, index, sPattern.fillerPattern.size(), totalIndex, totalSize, slotIndex) + " ";
                ++index;
                ++totalIndex;
            }
            index = 0;
            for (TextRulerRuleItem item : sPattern.postFillerPattern) {
                ruleString = ruleString + item.getStringForRuleString(this, TextRulerRuleItem.MLRuleItemType.POSTFILLER, index, sPattern.postFillerPattern.size(), totalIndex, totalSize, slotIndex) + " ";
                ++index;
                ++totalIndex;
            }
            if (this.slotPatterns.size() <= 1 || slotIndex >= this.slotPatterns.size() - 1) continue;
            ruleString = ruleString + this.getInterslotWildCard();
            ++totalIndex;
        }
        ruleString = ruleString.trim();
        this.ruleString = ruleString = ruleString + ";";
        this.setNeedsCompile(false);
    }

    public List<TextRulerSlotPattern> getPatterns() {
        return this.slotPatterns;
    }

    @Override
    public TextRulerMultiSlotRule copy() {
        return new TextRulerMultiSlotRule(this);
    }
}

