/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.wizards;

import java.util.List;
import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.wizards.NewSourceModulePage;

public class RutaFileCreationPage
extends NewSourceModulePage {
    protected String getPageDescription() {
        return "This wizard creates a new Ruta script file.";
    }

    protected String getFileContent() {
        IPath fullPath;
        StringBuilder sb = new StringBuilder();
        IScriptFolder scriptFolder = this.getScriptFolder();
        IScriptProject scriptProject = scriptFolder.getScriptProject();
        IFolder folder = null;
        try {
            folder = this.getScriptFolderOf(scriptFolder, scriptProject);
        }
        catch (ModelException e) {
            RutaIdeUIPlugin.error(e);
        }
        if (folder == null) {
            return "";
        }
        IPath path = scriptFolder.getPath();
        IPath relativeTo = path.makeRelativeTo(fullPath = folder.getFullPath());
        if (!relativeTo.isEmpty()) {
            sb.append("PACKAGE ");
            String pathString = "";
            for (int i = 0; i < relativeTo.segments().length; ++i) {
                pathString = pathString + relativeTo.segments()[i];
                if (i >= relativeTo.segments().length - 1) continue;
                pathString = pathString + ".";
            }
            sb.append(pathString);
            sb.append(";\n");
        }
        return sb.toString();
    }

    private IFolder getScriptFolderOf(IScriptFolder scriptFolder, IScriptProject scriptProject) throws ModelException {
        List scriptFolders = RutaProjectUtils.getScriptFolders((IScriptProject)scriptProject);
        for (IFolder each : scriptFolders) {
            if (each.equals(scriptFolder.getResource())) {
                return each;
            }
            IPath path = scriptFolder.getPath().makeRelativeTo(each.getFullPath());
            IResource findMember = each.findMember(path);
            if (findMember == null || !(findMember instanceof IFolder)) continue;
            return each;
        }
        return null;
    }

    protected String getRequiredNature() {
        return "org.apache.uima.ruta.ide.nature";
    }

    protected String getPageTitle() {
        return "Create a new Ruta script file";
    }
}

