/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.ide.core.builder.DescriptorManager;
import org.apache.uima.ruta.ide.core.builder.RutaBuildException;
import org.apache.uima.ruta.ide.core.builder.RutaBuildOptions;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.core.builder.StringTriple;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RutaSimpleBuilder {
    private static ResourceSpecifierFactory uimaFactory = UIMAFramework.getResourceSpecifierFactory();
    private TypeSystemDescription typeSystemDescription;
    private AnalysisEngineDescription analysisEngineDescription;
    private final String defaultTypeSystem;
    private ResourceManager rm;

    public RutaSimpleBuilder(String defaultTypeSystem, String defaultEngine) throws InvalidXMLException, IOException {
        this.defaultTypeSystem = defaultTypeSystem;
        this.initialize(defaultEngine);
    }

    private void initialize(String defaultEngine) throws InvalidXMLException, IOException {
        this.typeSystemDescription = uimaFactory.createTypeSystemDescription();
        this.analysisEngineDescription = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(new File(defaultEngine)));
    }

    public void build(DescriptorManager desc, String typeSystemOutput, String engineOutput, RutaBuildOptions option, String mainScript, String[] scriptPaths, String[] enginePaths, ClassLoader classloader) throws SAXException, RutaBuildException, InvalidXMLException, IOException, ResourceInitializationException {
        String absoluteLocation;
        TypeSystemDescription each;
        String locate;
        this.rm = new ResourceManager_impl(classloader);
        String dataPath = "";
        for (String string : enginePaths) {
            dataPath = dataPath + string + File.pathSeparator;
        }
        this.rm.setDataPath(dataPath);
        HashMap<String, String> typeNameMap = new HashMap<String, String>();
        Capability capability = uimaFactory.createCapability();
        File defaultTypeSystemFile = new File(this.defaultTypeSystem);
        if (!defaultTypeSystemFile.exists()) {
            System.out.println("Does not exist: " + defaultTypeSystemFile.getName());
        }
        TypeSystemDescription initialTypeSystem = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(defaultTypeSystemFile));
        CAS cas = CasCreationUtils.createCas((TypeSystemDescription)initialTypeSystem, null, (FsIndexDescription[])new FsIndexDescription[0]);
        this.fillTypeNameMap(typeNameMap, cas.getTypeSystem());
        cas.release();
        ArrayList<TypeSystemDescription> toInclude = new ArrayList<TypeSystemDescription>();
        ArrayList<Import_impl> importList = new ArrayList<Import_impl>();
        Import_impl import_impl = new Import_impl();
        if (option.isImportByName()) {
            String name = initialTypeSystem.getName();
            import_impl.setName(name);
        } else if (option.isResolveImports()) {
            String absoluteLocation2 = initialTypeSystem.getSourceUrlString();
            import_impl.setLocation(absoluteLocation2);
        } else {
            String relativeLocation = this.getRelativeLocation(defaultTypeSystemFile.getAbsolutePath(), typeSystemOutput);
            import_impl.setLocation(relativeLocation);
        }
        importList.add(import_impl);
        for (String eachName : desc.getImportedTypeSystems()) {
            locate = RutaEngine.locate((String)eachName, (String[])enginePaths, (String)".xml");
            URL url = null;
            boolean include = false;
            if (locate != null) {
                File file = new File(locate);
                url = file.toURI().toURL();
            }
            if (url == null) {
                url = RutaSimpleBuilder.checkImportExistence(eachName, "xml", classloader);
                include = true;
                if (url == null) {
                    throw new FileNotFoundException("Build process can't find " + eachName + " in " + mainScript);
                }
            }
            if ((each = this.getTypeSystemDescriptor(url, option)) != null) {
                this.fillTypeNameMap(typeNameMap, each);
                if (include) {
                    each.resolveImports(this.rm);
                    toInclude.add(each);
                    continue;
                }
                import_impl = new Import_impl();
                if (option.isImportByName()) {
                    import_impl.setName(eachName);
                } else if (option.isResolveImports()) {
                    absoluteLocation = each.getSourceUrlString();
                    import_impl.setLocation(absoluteLocation);
                } else {
                    String path = url.getPath();
                    String relativeLocation = this.getRelativeLocation(path, typeSystemOutput);
                    File parentFile = new File(typeSystemOutput).getParentFile();
                    File targetFile = new File(parentFile, relativeLocation);
                    boolean ableToFindFile = targetFile.exists();
                    if (!ableToFindFile) {
                        import_impl.setName(eachName);
                    } else {
                        import_impl.setLocation(relativeLocation);
                    }
                }
                importList.add(import_impl);
                continue;
            }
            throw new FileNotFoundException("Build process can't find " + eachName + " in " + mainScript);
        }
        for (String eachName : desc.getImportedScripts()) {
            locate = RutaEngine.locate((String)eachName, (String[])enginePaths, (String)"TypeSystem.xml");
            File file = new File(locate);
            URL url = file.toURI().toURL();
            each = this.getTypeSystemDescriptor(url, option);
            if (each != null) {
                this.fillTypeNameMap(typeNameMap, each);
                import_impl = new Import_impl();
                if (option.isImportByName()) {
                    import_impl.setName(eachName + "TypeSystem");
                } else if (option.isResolveImports()) {
                    absoluteLocation = each.getSourceUrlString();
                    import_impl.setLocation(absoluteLocation);
                } else {
                    String relativeLocation = this.getRelativeLocation(file.getAbsolutePath(), typeSystemOutput);
                    import_impl.setLocation(relativeLocation);
                }
                importList.add(import_impl);
                continue;
            }
            throw new FileNotFoundException("Build process can't find " + eachName + " in " + mainScript);
        }
        this.typeSystemDescription = CasCreationUtils.mergeTypeSystems(toInclude, (ResourceManager)this.rm);
        Import[] newImports = importList.toArray(new Import[0]);
        this.typeSystemDescription.setImports(newImports);
        if (option.isResolveImports()) {
            try {
                this.typeSystemDescription.resolveImports(this.rm);
            }
            catch (InvalidXMLException e) {
                throw new RutaBuildException("Failed to resolve imported Type Systems", e);
            }
        }
        HashSet<String> finalTypes = new HashSet<String>();
        finalTypes.addAll(Arrays.asList("uima.cas.Boolean", "uima.cas.Byte", "uima.cas.Short", "uima.cas.Integer", "uima.cas.Long", "uima.cas.Float", "uima.cas.Double", "uima.cas.BooleanArray", "uima.cas.ByteArray", "uima.cas.ShortArray", "uima.cas.IntegerArray", "uima.cas.LongArray", "uima.cas.FloatArray", "uima.cas.DoubleArray", "uima.cas.StringArray", "uima.cas.FSArray"));
        int typeIndex = 0;
        for (String eachType : desc.getTypeShortNames()) {
            StringTriple typeTriple = desc.getTypeTriples().get(typeIndex);
            if (this.typeSystemDescription.getType((typeTriple = this.resolveType(typeTriple, typeNameMap, mainScript)).getName()) != null) continue;
            if (!finalTypes.contains(typeTriple.getParent())) {
                TypeDescription newType = this.typeSystemDescription.addType(typeTriple.getName(), typeTriple.getDescription(), typeTriple.getParent());
                capability.addInputType(typeTriple.getName(), false);
                capability.addOutputType(typeTriple.getName(), false);
                Collection<StringTriple> collection = desc.getFeatures().get(eachType);
                if (collection != null) {
                    for (StringTriple eachFeature : collection) {
                        eachFeature = this.resolveFeature(eachFeature, typeNameMap);
                        newType.addFeature(eachFeature.getName(), eachFeature.getDescription(), eachFeature.getParent());
                    }
                }
            }
            ++typeIndex;
        }
        HashSet<String> names = new HashSet<String>();
        ArrayList<TypeDescription> types = new ArrayList<TypeDescription>();
        for (TypeDescription each2 : this.typeSystemDescription.getTypes()) {
            String name = each2.getName();
            if (names.contains(name)) continue;
            names.add(name);
            types.add(each2);
        }
        File typeSystemFile = this.getFile(typeSystemOutput);
        TypeDescription[] presentTypes = this.typeSystemDescription.getTypes();
        types.addAll(Arrays.asList(presentTypes));
        this.typeSystemDescription.setTypes(types.toArray(new TypeDescription[0]));
        this.typeSystemDescription.setName(mainScript + "TypeSystem");
        this.typeSystemDescription.setSourceUrl(typeSystemFile.toURI().toURL());
        TypeSystemDescription aets = uimaFactory.createTypeSystemDescription();
        import_impl = new Import_impl();
        if (option.isImportByName()) {
            import_impl.setName(this.typeSystemDescription.getName());
        } else {
            String relativeLocation = this.getRelativeLocation(engineOutput, typeSystemOutput);
            import_impl.setLocation(relativeLocation);
        }
        File engineFile = this.configureEngine(desc, engineOutput, option, mainScript, scriptPaths, enginePaths, capability, import_impl, aets);
        this.toFile((XMLizable)this.typeSystemDescription, typeSystemFile);
        this.toFile((XMLizable)this.analysisEngineDescription, engineFile);
    }

    private void fillTypeNameMap(Map<String, String> typeNameMap, TypeSystem typeSystem) {
        Iterator typeIterator = typeSystem.getTypeIterator();
        while (typeIterator.hasNext()) {
            Type type = (Type)typeIterator.next();
            String shortName = type.getShortName();
            String name = type.getName();
            typeNameMap.put(shortName, name);
        }
    }

    private boolean fillTypeNameMap(Map<String, String> typeNameMap, TypeSystemDescription desc) {
        boolean contained = false;
        for (TypeDescription each : desc.getTypes()) {
            String name = each.getName();
            int lastIndexOf = name.lastIndexOf(".");
            String shortName = name.substring(lastIndexOf + 1, name.length());
            typeNameMap.put(shortName, name);
        }
        return contained;
    }

    private StringTriple resolveFeature(StringTriple eachFeature, Map<String, String> types) {
        String parent = eachFeature.getParent();
        String name = eachFeature.getName();
        if ((parent = this.translate(parent)).indexOf(".") == -1 && types.containsKey(parent)) {
            parent = types.get(parent);
        }
        return new StringTriple(name, eachFeature.getDescription(), parent);
    }

    private StringTriple resolveType(StringTriple typeTriple, Map<String, String> types, String packageName) {
        String parent = typeTriple.getParent();
        String name = typeTriple.getName();
        if (parent == null) {
            parent = "uima.tcas.Annotation";
        }
        parent = this.translate(parent);
        name = this.translate(name);
        if (parent.indexOf(".") == -1 && types.containsKey(parent)) {
            parent = types.get(parent);
        }
        if (name.indexOf(".") == -1) {
            name = types.containsKey(name) ? types.get(name) : packageName + "." + name;
        }
        int lastIndexOf = name.lastIndexOf(".");
        String shortName = name.substring(lastIndexOf + 1, name.length());
        types.put(shortName, name);
        return new StringTriple(name, typeTriple.getDescription(), parent);
    }

    private String translate(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("Annotation")) {
            return "uima.tcas.Annotation";
        }
        if (name.equals("STRING")) {
            return "uima.cas.String";
        }
        if (name.equals("INT")) {
            return "uima.cas.Integer";
        }
        if (name.equals("DOUBLE")) {
            return "uima.cas.Double";
        }
        if (name.equals("FLOAT")) {
            return "uima.cas.Float";
        }
        if (name.equals("BOOLEAN")) {
            return "uima.cas.Boolean";
        }
        if (name.equals("TYPE")) {
            return "uima.cas.String";
        }
        return name;
    }

    private File configureEngine(DescriptorManager desc, String engineOutput, RutaBuildOptions option, String mainScript, String[] scriptPaths, String[] descriptorPaths, Capability capability, Import_impl import_impl, TypeSystemDescription aets) throws MalformedURLException {
        aets.setImports(new Import[]{import_impl});
        this.analysisEngineDescription.getAnalysisEngineMetaData().setTypeSystem(aets);
        File file = this.getFile(engineOutput);
        this.analysisEngineDescription.setSourceUrl(file.toURI().toURL());
        if (!desc.getTypeShortNames().isEmpty()) {
            Capability[] capabilities = this.analysisEngineDescription.getAnalysisEngineMetaData().getCapabilities();
            Capability[] newArray = new Capability[capabilities.length + 1];
            System.arraycopy(capabilities, 0, newArray, 0, capabilities.length);
            newArray[capabilities.length] = capability;
            this.analysisEngineDescription.getAnalysisEngineMetaData().setCapabilities(newArray);
        }
        this.analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("mainScript", (Object)mainScript);
        this.analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("scriptPaths", (Object)scriptPaths);
        this.analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("descriptorPaths", (Object)descriptorPaths);
        String[] parameterValue = (String[])this.analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().getParameterValue("resourcePaths");
        HashSet<String> resourceLocations = new HashSet<String>();
        if (parameterValue != null && parameterValue.length != 0) {
            resourceLocations.addAll(Arrays.asList(parameterValue));
        }
        for (String string : descriptorPaths) {
            File descDir = new File(string);
            File defaultResourceDir = new File(descDir.getParent(), RutaProjectUtils.getDefaultResourcesLocation());
            resourceLocations.add(defaultResourceDir.getAbsolutePath());
        }
        this.analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("resourcePaths", (Object)resourceLocations.toArray(new String[0]));
        String[] additionalScriptsArray = desc.getImportedScripts().toArray(new String[0]);
        this.analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("additionalScripts", (Object)additionalScriptsArray);
        String[] additionalEnginesArray = desc.getImportedEngines().toArray(new String[0]);
        this.analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("additionalEngines", (Object)additionalEnginesArray);
        String[] additionalUimafitEnginesArray = desc.getImportedUimafitEngines().toArray(new String[0]);
        this.analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("additionalUimafitEngines", (Object)additionalUimafitEnginesArray);
        this.analysisEngineDescription.getAnalysisEngineMetaData().setTypeSystem(this.typeSystemDescription);
        this.configureExtensions(option);
        return file;
    }

    private String getRelativeLocation(String target, String base) {
        IPath targetPath = Path.fromOSString((String)target);
        IPath basePath = Path.fromPortableString((String)base);
        IPath result = targetPath.makeRelativeTo(basePath);
        result = result.removeFirstSegments(1);
        return result.toPortableString();
    }

    private void configureExtensions(RutaBuildOptions options) {
        ConfigurationParameterSettings configurationParameterSettings = this.analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings();
        List<String> languageExtensions = options.getLanguage();
        configurationParameterSettings.setParameterValue("additionalExtensions", (Object)languageExtensions.toArray(new String[0]));
        configurationParameterSettings.setParameterValue("additionalEngineLoaders", (Object)options.getEngines().toArray(new String[0]));
    }

    private TypeSystemDescription getTypeSystemDescriptor(URL url, RutaBuildOptions option) throws InvalidXMLException, IOException {
        TypeSystemDescription tsdesc = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(url));
        if (option.isResolveImports()) {
            tsdesc.resolveImports(this.rm);
        }
        return tsdesc;
    }

    private File getFile(String location) {
        return new File(location);
    }

    private void toFile(XMLizable desc, File destination) throws SAXException, FileNotFoundException {
        destination.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(destination);
        XMLSerializer sax = new XMLSerializer((OutputStream)out);
        ContentHandler ch = sax.getContentHandler();
        ch.startDocument();
        desc.toXML(ch);
        ch.endDocument();
    }

    public static URL checkImportExistence(String candidate, String extension, ClassLoader classloader) throws IOException {
        String p = candidate.replaceAll("[.]", "/");
        p = p + "." + extension;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classloader);
        String prefix = "classpath*:";
        String pattern = prefix + p;
        Resource[] resources = resolver.getResources(pattern);
        if (resources == null || resources.length == 0) {
            return null;
        }
        Resource resource = resources[0];
        URL url = resource.getURL();
        return url;
    }
}

