/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.commands.info.InfoProvider;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Command(scope="shell", name="info", description="Prints system information.")
@Service
public class InfoAction
implements Action {
    private NumberFormat fmtI = new DecimalFormat("###,###", new DecimalFormatSymbols(Locale.ENGLISH));
    private NumberFormat fmtDec = new DecimalFormat("###,###.##", new DecimalFormatSymbols(Locale.ENGLISH));
    private NumberFormat fmtD = new DecimalFormat("###,##0.000", new DecimalFormatSymbols(Locale.ENGLISH));
    private OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
    @Option(name="--memory-pools", aliases={"-mp"}, description="Includes detailed information about memory pools")
    protected boolean showMemoryPools;
    List<InfoProvider> infoProviders;

    public InfoAction() {
        this.fmtDec.setMinimumFractionDigits(2);
    }

    public Object execute() throws Exception {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        int maxNameLen = 25;
        System.out.println("Karaf");
        this.printValue("Karaf version", maxNameLen, System.getProperty("karaf.version"));
        this.printValue("Karaf home", maxNameLen, System.getProperty("karaf.home"));
        this.printValue("Karaf base", maxNameLen, System.getProperty("karaf.base"));
        String osgi = this.getOsgiFramework();
        if (osgi != null) {
            this.printValue("OSGi Framework", maxNameLen, osgi);
        }
        System.out.println();
        System.out.println("JVM");
        this.printValue("Java Virtual Machine", maxNameLen, runtime.getVmName() + " version " + runtime.getVmVersion());
        this.printValue("Version", maxNameLen, System.getProperty("java.version"));
        this.printValue("Vendor", maxNameLen, runtime.getVmVendor());
        this.printValue("Pid", maxNameLen, this.getPid());
        this.printValue("Uptime", maxNameLen, this.printDuration(runtime.getUptime()));
        try {
            Class<?> sunOS = Class.forName("com.sun.management.OperatingSystemMXBean");
            this.printValue("Process CPU time", maxNameLen, this.printDuration(this.getValueAsLong(sunOS, "getProcessCpuTime") / 1000000L));
            this.printValue("Process CPU load", maxNameLen, this.fmtDec.format(this.getValueAsDouble(sunOS, "getProcessCpuLoad")));
            this.printValue("System CPU load", maxNameLen, this.fmtDec.format(this.getValueAsDouble(sunOS, "getSystemCpuLoad")));
        }
        catch (Throwable sunOS) {
            // empty catch block
        }
        try {
            Class<?> unixOS = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
            this.printValue("Open file descriptors", maxNameLen, this.printLong(this.getValueAsLong(unixOS, "getOpenFileDescriptorCount")));
            this.printValue("Max file descriptors", maxNameLen, this.printLong(this.getValueAsLong(unixOS, "getMaxFileDescriptorCount")));
        }
        catch (Throwable unixOS) {
            // empty catch block
        }
        this.printValue("Total compile time", maxNameLen, this.printDuration(ManagementFactory.getCompilationMXBean().getTotalCompilationTime()));
        System.out.println("Threads");
        this.printValue("Live threads", maxNameLen, Integer.toString(threads.getThreadCount()));
        this.printValue("Daemon threads", maxNameLen, Integer.toString(threads.getDaemonThreadCount()));
        this.printValue("Peak", maxNameLen, Integer.toString(threads.getPeakThreadCount()));
        this.printValue("Total started", maxNameLen, Long.toString(threads.getTotalStartedThreadCount()));
        System.out.println("Memory");
        this.printValue("Current heap size", maxNameLen, this.printSizeInKb(mem.getHeapMemoryUsage().getUsed()));
        this.printValue("Maximum heap size", maxNameLen, this.printSizeInKb(mem.getHeapMemoryUsage().getMax()));
        this.printValue("Committed heap size", maxNameLen, this.printSizeInKb(mem.getHeapMemoryUsage().getCommitted()));
        this.printValue("Pending objects", maxNameLen, Integer.toString(mem.getObjectPendingFinalizationCount()));
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            String val = "Name = '" + gc.getName() + "', Collections = " + gc.getCollectionCount() + ", Time = " + this.printDuration(gc.getCollectionTime());
            this.printValue("Garbage collector", maxNameLen, val);
        }
        if (this.showMemoryPools) {
            List<MemoryPoolMXBean> memoryPools = ManagementFactory.getMemoryPoolMXBeans();
            System.out.println("Memory Pools");
            this.printValue("Total Memory Pools", maxNameLen, this.printLong(memoryPools.size()));
            String spaces4 = "   ";
            for (MemoryPoolMXBean pool : memoryPools) {
                String name = pool.getName();
                MemoryType type = pool.getType();
                this.printValue((String)spaces4 + "Pool (" + (Object)((Object)type) + ")", maxNameLen, name);
                MemoryUsage peakUsage = pool.getPeakUsage();
                MemoryUsage usage = pool.getUsage();
                if (usage == null || peakUsage == null) continue;
                long init = peakUsage.getInit();
                long used = peakUsage.getUsed();
                long committed = peakUsage.getCommitted();
                long max = peakUsage.getMax();
                System.out.println((String)spaces4 + (String)spaces4 + "Peak Usage");
                this.printValue((String)spaces4 + (String)spaces4 + (String)spaces4 + "init", maxNameLen, this.printLong(init));
                this.printValue((String)spaces4 + (String)spaces4 + (String)spaces4 + "used", maxNameLen, this.printLong(used));
                this.printValue((String)spaces4 + (String)spaces4 + (String)spaces4 + "committed", maxNameLen, this.printLong(committed));
                this.printValue((String)spaces4 + (String)spaces4 + (String)spaces4 + "max", maxNameLen, this.printLong(max));
                init = usage.getInit();
                used = usage.getUsed();
                committed = usage.getCommitted();
                max = usage.getMax();
                System.out.println((String)spaces4 + (String)spaces4 + "Current Usage");
                this.printValue((String)spaces4 + (String)spaces4 + (String)spaces4 + "init", maxNameLen, this.printLong(init));
                this.printValue((String)spaces4 + (String)spaces4 + (String)spaces4 + "used", maxNameLen, this.printLong(used));
                this.printValue((String)spaces4 + (String)spaces4 + (String)spaces4 + "committed", maxNameLen, this.printLong(committed));
                this.printValue((String)spaces4 + (String)spaces4 + (String)spaces4 + "max", maxNameLen, this.printLong(max));
            }
        }
        System.out.println("Classes");
        this.printValue("Current classes loaded", maxNameLen, this.printLong(cl.getLoadedClassCount()));
        this.printValue("Total classes loaded", maxNameLen, this.printLong(cl.getTotalLoadedClassCount()));
        this.printValue("Total classes unloaded", maxNameLen, this.printLong(cl.getUnloadedClassCount()));
        System.out.println("Operating system");
        this.printValue("Name", maxNameLen, this.os.getName() + " version " + this.os.getVersion());
        this.printValue("Architecture", maxNameLen, this.os.getArch());
        this.printValue("Processors", maxNameLen, Integer.toString(this.os.getAvailableProcessors()));
        try {
            this.printValue("Total physical memory", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(this.os, "getTotalPhysicalMemorySize")));
            this.printValue("Free physical memory", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(this.os, "getFreePhysicalMemorySize")));
            this.printValue("Committed virtual memory", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(this.os, "getCommittedVirtualMemorySize")));
            this.printValue("Total swap space", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(this.os, "getTotalSwapSpaceSize")));
            this.printValue("Free swap space", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(this.os, "getFreeSwapSpaceSize")));
        }
        catch (Throwable memoryPools) {
            // empty catch block
        }
        HashMap<String, Properties> properties = new HashMap<String, Properties>();
        if (this.infoProviders != null) {
            for (InfoProvider provider : this.infoProviders) {
                if (!properties.containsKey(provider.getName())) {
                    properties.put(provider.getName(), new Properties());
                }
                ((Map)properties.get(provider.getName())).putAll(provider.getProperties());
            }
            ArrayList sections = new ArrayList(properties.keySet());
            Collections.sort(sections);
            for (String section : sections) {
                ArrayList keys = new ArrayList(((Map)properties.get(section)).keySet());
                if (keys.size() <= 0) continue;
                System.out.println(section);
                keys.sort(Comparator.comparing(String::valueOf));
                for (Object key : keys) {
                    this.printValue(String.valueOf(key), maxNameLen, String.valueOf(((Map)properties.get(section)).get(key)));
                }
            }
        }
        return null;
    }

    private String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] parts = name.split("@");
        return parts[0];
    }

    private long getSunOsValueAsLong(OperatingSystemMXBean os, String name) throws Exception {
        Method mth = os.getClass().getMethod(name, new Class[0]);
        return (Long)mth.invoke((Object)os, new Object[0]);
    }

    private long getValueAsLong(Class<?> osImpl, String name) throws Exception {
        if (osImpl.isInstance(this.os)) {
            Method mth = osImpl.getMethod(name, new Class[0]);
            return (Long)mth.invoke((Object)this.os, new Object[0]);
        }
        return -1L;
    }

    private double getValueAsDouble(Class<?> osImpl, String name) throws Exception {
        if (osImpl.isInstance(this.os)) {
            Method mth = osImpl.getMethod(name, new Class[0]);
            return (Double)mth.invoke((Object)this.os, new Object[0]);
        }
        return -1.0;
    }

    private String printLong(long i) {
        return this.fmtI.format(i);
    }

    private String printSizeInKb(double size) {
        return this.fmtI.format((long)(size / 1024.0)) + " kbytes";
    }

    protected String printDuration(double uptime) {
        if ((uptime /= 1000.0) < 60.0) {
            return this.fmtD.format(uptime) + " seconds";
        }
        if ((uptime /= 60.0) < 60.0) {
            long minutes = (long)uptime;
            String s = this.fmtI.format(minutes) + (minutes > 1L ? " minutes" : " minute");
            return s;
        }
        if ((uptime /= 60.0) < 24.0) {
            long hours = (long)uptime;
            long minutes = (long)((uptime - (double)hours) * 60.0);
            String s = this.fmtI.format(hours) + (hours > 1L ? " hours" : " hour");
            if (minutes != 0L) {
                s = s + " " + this.fmtI.format(minutes) + (minutes > 1L ? " minutes" : " minute");
            }
            return s;
        }
        long days = (long)(uptime /= 24.0);
        long hours = (long)((uptime - (double)days) * 24.0);
        String s = this.fmtI.format(days) + (days > 1L ? " days" : " day");
        if (hours != 0L) {
            s = s + " " + this.fmtI.format(hours) + (hours > 1L ? " hours" : " hour");
        }
        return s;
    }

    void printSysValue(String prop, int pad) {
        this.printValue(prop, pad, System.getProperty(prop));
    }

    void printValue(String name, int pad, String value) {
        System.out.println("  " + SimpleAnsi.INTENSITY_BOLD + name + SimpleAnsi.INTENSITY_NORMAL + this.spaces(pad - name.length()) + "   " + value);
    }

    String spaces(int nb) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nb; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    String getOsgiFramework() {
        try {
            Callable<String> call = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                    Bundle sysBundle = context.getBundle(0L);
                    return sysBundle.getSymbolicName() + "-" + sysBundle.getVersion();
                }
            };
            return (String)call.call();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

