/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.cluster;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.unomi.services.impl.cluster.ClusterServiceImpl;
import org.apache.unomi.services.impl.cluster.ClusterSystemStatisticsEvent;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSystemStatisticsEventHandler
extends CellarSupport
implements EventHandler<ClusterSystemStatisticsEvent> {
    public static final String SWITCH_ID = "org.apache.unomi.cluster.system.statistics.handler";
    private static final Logger logger = LoggerFactory.getLogger((String)ClusterSystemStatisticsEventHandler.class.getName());
    private final Switch eventSwitch = new BasicSwitch("org.apache.unomi.cluster.system.statistics.handler");
    private ClusterServiceImpl clusterServiceImpl;

    public void setClusterServiceImpl(ClusterServiceImpl clusterServiceImpl) {
        this.clusterServiceImpl = clusterServiceImpl;
    }

    public void init() {
    }

    public void destroy() {
    }

    public void handle(ClusterSystemStatisticsEvent event) {
        if (this.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            logger.debug("CELLAR SYSTEM STATS: {} switch is OFF, cluster event not handled", (Object)SWITCH_ID);
            return;
        }
        if (this.groupManager == null) {
            logger.error("CELLAR SYSTEM STATS: retrieved event {} while groupManager is not available yet!", (Object)event);
            return;
        }
        if (!this.groupManager.isLocalGroup(event.getSourceGroup().getName())) {
            logger.info("CELLAR SYSTEM STATS: node is not part of the event cluster group {}", (Object)event.getSourceGroup().getName());
            return;
        }
        Group group = event.getSourceGroup();
        String groupName = group.getName();
        String pid = event.getId();
        if (this.isAllowed(event.getSourceGroup(), "config", pid, EventType.INBOUND).booleanValue()) {
            if (event.getSourceNode() != null && event.getSourceNode().getId().equalsIgnoreCase(this.clusterManager.getNode().getId())) {
                logger.trace("CELLAR SYSTEM STATS: cluster event is local (coming from local synchronizer or listener)");
                return;
            }
            Map<String, Serializable> nodeSystemStatistics = this.clusterServiceImpl.getNodeSystemStatistics().get(event.getSourceNode().getId());
            if (nodeSystemStatistics == null) {
                nodeSystemStatistics = new ConcurrentHashMap<String, Serializable>();
            }
            nodeSystemStatistics.putAll(event.getStatistics());
            this.clusterServiceImpl.getNodeSystemStatistics().put(event.getSourceNode().getId(), nodeSystemStatistics);
        }
    }

    public Class<ClusterSystemStatisticsEvent> getType() {
        return ClusterSystemStatisticsEvent.class;
    }

    public Switch getSwitch() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null) {
                String handlerStatus = (String)configuration.getProperties().get("handler." + ((Object)((Object)this)).getClass().getName());
                if (handlerStatus == null) {
                    this.eventSwitch.turnOn();
                } else {
                    Boolean status = new Boolean(handlerStatus);
                    if (status.booleanValue()) {
                        this.eventSwitch.turnOn();
                    } else {
                        this.eventSwitch.turnOff();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.eventSwitch;
    }
}

