/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.fs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.fs.SftpFileSystemProvider;
import org.apache.sshd.client.subsystem.sftp.impl.AbstractSftpFileAttributeView;

public class SftpAclFileAttributeView
extends AbstractSftpFileAttributeView
implements AclFileAttributeView {
    public SftpAclFileAttributeView(SftpFileSystemProvider provider, Path path, LinkOption ... options) {
        super(provider, path, options);
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        PosixFileAttributes v = this.provider.readAttributes(this.path, PosixFileAttributes.class, this.options);
        return v.owner();
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
        this.provider.setAttribute(this.path, "posix", "owner", owner, this.options);
    }

    @Override
    public String name() {
        return "acl";
    }

    @Override
    public List<AclEntry> getAcl() throws IOException {
        return this.readRemoteAttributes().getAcl();
    }

    @Override
    public void setAcl(List<AclEntry> acl) throws IOException {
        this.writeRemoteAttributes(new SftpClient.Attributes().acl(acl));
    }
}

