/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverterExistsException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.TypeConverters;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.ArrayTypeConverter;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.impl.converter.CoreTypeConverterLoader;
import org.apache.camel.impl.converter.EnumTypeConverter;
import org.apache.camel.impl.converter.FutureTypeConverter;
import org.apache.camel.impl.converter.OptimisedTypeConverter;
import org.apache.camel.impl.converter.ToStringTypeConverter;
import org.apache.camel.impl.converter.TypeConvertersLoader;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterAware;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.LRUSoftCache;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTypeConverterRegistry
extends ServiceSupport
implements TypeConverter,
TypeConverterRegistry,
CamelContextAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final OptimisedTypeConverter optimisedTypeConverter = new OptimisedTypeConverter();
    protected final ConcurrentMap<TypeMapping, TypeConverter> typeMappings = new ConcurrentHashMap<TypeMapping, TypeConverter>();
    protected final LRUSoftCache<TypeMapping, TypeMapping> misses = LRUCacheFactory.newLRUSoftCache(1000);
    protected final List<TypeConverterLoader> typeConverterLoaders = new ArrayList<TypeConverterLoader>();
    protected final List<FallbackTypeConverter> fallbackConverters = new CopyOnWriteArrayList<FallbackTypeConverter>();
    protected final PackageScanClassResolver resolver;
    protected CamelContext camelContext;
    protected Injector injector;
    protected final FactoryFinder factoryFinder;
    protected TypeConverterExists typeConverterExists = TypeConverterExists.Override;
    protected LoggingLevel typeConverterExistsLoggingLevel = LoggingLevel.WARN;
    protected final TypeConverterRegistry.Statistics statistics = new UtilizationStatistics();
    protected final LongAdder noopCounter = new LongAdder();
    protected final LongAdder attemptCounter = new LongAdder();
    protected final LongAdder missCounter = new LongAdder();
    protected final LongAdder baseHitCounter = new LongAdder();
    protected final LongAdder hitCounter = new LongAdder();
    protected final LongAdder failedCounter = new LongAdder();

    public BaseTypeConverterRegistry(PackageScanClassResolver resolver, Injector injector, FactoryFinder factoryFinder) {
        this.resolver = resolver;
        this.injector = injector;
        this.factoryFinder = factoryFinder;
        this.typeConverterLoaders.add(new AnnotationTypeConverterLoader(resolver));
        ArrayList<FallbackTypeConverter> fallbacks = new ArrayList<FallbackTypeConverter>();
        this.addCoreFallbackTypeConverterToList(new ToStringTypeConverter(), false, fallbacks);
        this.addCoreFallbackTypeConverterToList(new EnumTypeConverter(), true, fallbacks);
        this.addCoreFallbackTypeConverterToList(new ArrayTypeConverter(), true, fallbacks);
        this.addCoreFallbackTypeConverterToList(new FutureTypeConverter(this), false, fallbacks);
        this.addCoreFallbackTypeConverterToList(new AsyncProcessorTypeConverter(), true, fallbacks);
        this.fallbackConverters.addAll(fallbacks);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<TypeConverterLoader> getTypeConverterLoaders() {
        return this.typeConverterLoaders;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        Object answer;
        if (!this.isRunAllowed()) {
            throw new IllegalStateException(this + " is not started");
        }
        try {
            answer = this.doConvertTo(type, exchange, value, false);
        }
        catch (Exception e) {
            boolean execution;
            if (this.statistics.isStatisticsEnabled()) {
                this.failedCounter.increment();
            }
            boolean bl = execution = ObjectHelper.getException(ExecutionException.class, e) != null || ObjectHelper.getException(CamelExecutionException.class, e) != null;
            if (execution) {
                throw ObjectHelper.wrapCamelExecutionException(exchange, e);
            }
            if (e instanceof TypeConversionException) {
                throw (TypeConversionException)e;
            }
            throw this.createTypeConversionException(exchange, type, value, e);
        }
        if (answer == Void.TYPE) {
            if (this.statistics.isStatisticsEnabled()) {
                this.missCounter.increment();
            }
            return null;
        }
        if (this.statistics.isStatisticsEnabled()) {
            this.hitCounter.increment();
        }
        return (T)answer;
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, null, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        Object answer;
        if (!this.isRunAllowed()) {
            throw new IllegalStateException(this + " is not started");
        }
        try {
            answer = this.doConvertTo(type, exchange, value, false);
        }
        catch (Exception e) {
            if (this.statistics.isStatisticsEnabled()) {
                this.failedCounter.increment();
            }
            if (e instanceof TypeConversionException) {
                throw (TypeConversionException)e;
            }
            throw this.createTypeConversionException(exchange, type, value, e);
        }
        if (answer == Void.TYPE || value == null) {
            if (this.statistics.isStatisticsEnabled()) {
                this.missCounter.increment();
            }
            throw new NoTypeConversionAvailableException(value, type);
        }
        if (this.statistics.isStatisticsEnabled()) {
            this.hitCounter.increment();
        }
        return (T)answer;
    }

    @Override
    public <T> T tryConvertTo(Class<T> type, Object value) {
        return this.tryConvertTo(type, null, value);
    }

    @Override
    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        Object answer;
        if (!this.isRunAllowed()) {
            return null;
        }
        try {
            answer = this.doConvertTo(type, exchange, value, true);
        }
        catch (Exception e) {
            if (this.statistics.isStatisticsEnabled()) {
                this.failedCounter.increment();
            }
            return null;
        }
        if (answer == Void.TYPE) {
            if (this.statistics.isStatisticsEnabled()) {
                this.missCounter.increment();
            }
            return null;
        }
        if (this.statistics.isStatisticsEnabled()) {
            this.hitCounter.increment();
        }
        return (T)answer;
    }

    protected Object doConvertTo(Class<?> type, Exchange exchange, Object value, boolean tryConvert) throws Exception {
        Object rc;
        Class<?> fromType;
        TypeConverter tc;
        Class<?> primitiveType;
        Object result;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Finding type converter to convert {} -> {} with value: {}", new Object[]{value == null ? "null" : value.getClass().getCanonicalName(), type.getCanonicalName(), value});
        }
        if (value == null) {
            if (this.statistics.isStatisticsEnabled()) {
                this.noopCounter.increment();
            }
            if (Boolean.TYPE == type) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            if (this.statistics.isStatisticsEnabled()) {
                this.noopCounter.increment();
            }
            return value;
        }
        if (value instanceof Float && value.equals(Float.valueOf(Float.NaN)) || value instanceof Double && value.equals(Double.NaN)) {
            if (this.statistics.isStatisticsEnabled()) {
                this.noopCounter.increment();
            }
            if (Float.class.isAssignableFrom(type)) {
                return Float.valueOf(Float.NaN);
            }
            if (Double.class.isAssignableFrom(type)) {
                return Double.NaN;
            }
            return Void.TYPE;
        }
        if (this.statistics.isStatisticsEnabled()) {
            this.attemptCounter.increment();
        }
        if ((result = this.optimisedTypeConverter.convertTo(type, exchange, value)) != null) {
            if (this.statistics.isStatisticsEnabled()) {
                this.baseHitCounter.increment();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Using optimised core converter to convert: {} -> {}", type, (Object)value.getClass().getCanonicalName());
            }
            return result;
        }
        TypeMapping key = new TypeMapping(type, value.getClass());
        if (this.misses.containsKey(key)) {
            return Void.TYPE;
        }
        TypeConverter converter = this.getOrFindTypeConverter(key);
        if (converter != null) {
            this.log.trace("Using converter: {} to convert {}", (Object)converter, (Object)key);
            Object rc2 = tryConvert ? converter.tryConvertTo(type, exchange, value) : converter.convertTo(type, exchange, value);
            if (rc2 == null && converter.allowNull()) {
                return null;
            }
            if (rc2 != null) {
                return rc2;
            }
        }
        if (type.isPrimitive() && (primitiveType = ObjectHelper.convertPrimitiveTypeToWrapperType(type)) != type && (tc = this.getOrFindTypeConverter(new TypeMapping(primitiveType, fromType = value.getClass()))) != null) {
            this.addTypeConverter(type, fromType, tc);
            rc = tryConvert ? tc.tryConvertTo(primitiveType, exchange, value) : tc.convertTo(primitiveType, exchange, value);
            if (rc == null && tc.allowNull()) {
                return null;
            }
            if (rc != null) {
                return rc;
            }
        }
        for (FallbackTypeConverter fallback : this.fallbackConverters) {
            tc = fallback.getFallbackTypeConverter();
            rc = tryConvert ? tc.tryConvertTo(type, exchange, value) : tc.convertTo(type, exchange, value);
            if (rc == null && tc.allowNull()) {
                return null;
            }
            if (Void.TYPE.equals(rc)) {
                return Void.TYPE;
            }
            if (rc == null) continue;
            if (fallback.isCanPromote()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Promoting fallback type converter as a known type converter to convert from: {} to: {} for the fallback converter: {}", new Object[]{type.getCanonicalName(), value.getClass().getCanonicalName(), fallback.getFallbackTypeConverter()});
                }
                this.addTypeConverter(type, value.getClass(), fallback.getFallbackTypeConverter());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Fallback type converter {} converted type from: {} to: {}", new Object[]{fallback.getFallbackTypeConverter(), type.getCanonicalName(), value.getClass().getCanonicalName()});
            }
            return rc;
        }
        if (!tryConvert) {
            this.misses.put(key, key);
        }
        return Void.TYPE;
    }

    @Override
    public void addTypeConverter(Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        this.log.trace("Adding type converter: {}", (Object)typeConverter);
        TypeMapping key = new TypeMapping(toType, fromType);
        TypeConverter converter = (TypeConverter)this.typeMappings.get(key);
        if (typeConverter != converter) {
            boolean add = true;
            if (converter != null) {
                if (this.typeConverterExists == TypeConverterExists.Override) {
                    CamelLogger logger = new CamelLogger(this.log, this.typeConverterExistsLoggingLevel);
                    logger.log("Overriding type converter from: " + converter + " to: " + typeConverter);
                } else if (this.typeConverterExists == TypeConverterExists.Ignore) {
                    CamelLogger logger = new CamelLogger(this.log, this.typeConverterExistsLoggingLevel);
                    logger.log("Ignoring duplicate type converter from: " + converter + " to: " + typeConverter);
                    add = false;
                } else {
                    throw new TypeConverterExistsException(toType, fromType);
                }
            }
            if (add) {
                this.typeMappings.put(key, typeConverter);
                this.misses.remove(key);
            }
        }
    }

    @Override
    public void addTypeConverters(TypeConverters typeConverters) {
        this.log.trace("Adding type converters: {}", (Object)typeConverters);
        try {
            TypeConvertersLoader loader = new TypeConvertersLoader(typeConverters);
            loader.load(this);
        }
        catch (TypeConverterLoaderException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public boolean removeTypeConverter(Class<?> toType, Class<?> fromType) {
        this.log.trace("Removing type converter from: {} to: {}", fromType, toType);
        TypeMapping key = new TypeMapping(toType, fromType);
        TypeConverter converter = (TypeConverter)this.typeMappings.remove(key);
        if (converter != null) {
            this.typeMappings.remove(key);
            this.misses.remove(key);
        }
        return converter != null;
    }

    @Override
    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        this.log.trace("Adding fallback type converter: {} which can promote: {}", (Object)typeConverter, (Object)canPromote);
        this.fallbackConverters.add(0, new FallbackTypeConverter(typeConverter, canPromote));
        if (typeConverter instanceof TypeConverterAware) {
            TypeConverterAware typeConverterAware = (TypeConverterAware)((Object)typeConverter);
            typeConverterAware.setTypeConverter(this);
        }
        if (typeConverter instanceof CamelContextAware) {
            CamelContextAware camelContextAware = (CamelContextAware)((Object)typeConverter);
            if (this.camelContext != null) {
                camelContextAware.setCamelContext(this.camelContext);
            }
        }
    }

    private void addCoreFallbackTypeConverterToList(TypeConverter typeConverter, boolean canPromote, List<FallbackTypeConverter> converters) {
        this.log.trace("Adding core fallback type converter: {} which can promote: {}", (Object)typeConverter, (Object)canPromote);
        converters.add(0, new FallbackTypeConverter(typeConverter, canPromote));
        if (typeConverter instanceof TypeConverterAware) {
            TypeConverterAware typeConverterAware = (TypeConverterAware)((Object)typeConverter);
            typeConverterAware.setTypeConverter(this);
        }
        if (typeConverter instanceof CamelContextAware) {
            CamelContextAware camelContextAware = (CamelContextAware)((Object)typeConverter);
            if (this.camelContext != null) {
                camelContextAware.setCamelContext(this.camelContext);
            }
        }
    }

    public TypeConverter getTypeConverter(Class<?> toType, Class<?> fromType) {
        TypeMapping key = new TypeMapping(toType, fromType);
        return (TypeConverter)this.typeMappings.get(key);
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public Set<Class<?>> getFromClassMappings() {
        HashSet answer = new HashSet();
        for (TypeMapping mapping : this.typeMappings.keySet()) {
            answer.add(mapping.getFromType());
        }
        return answer;
    }

    public Map<Class<?>, TypeConverter> getToClassMappings(Class<?> fromClass) {
        HashMap answer = new HashMap();
        for (Map.Entry entry : this.typeMappings.entrySet()) {
            TypeMapping mapping = (TypeMapping)entry.getKey();
            if (!mapping.isApplicable(fromClass)) continue;
            answer.put(mapping.getToType(), (TypeConverter)entry.getValue());
        }
        return answer;
    }

    public Map<TypeMapping, TypeConverter> getTypeMappings() {
        return this.typeMappings;
    }

    protected <T> TypeConverter getOrFindTypeConverter(TypeMapping key) {
        TypeConverter converter = (TypeConverter)this.typeMappings.get(key);
        if (converter == null && (converter = this.lookup(key.getToType(), key.getFromType())) != null) {
            this.typeMappings.putIfAbsent(key, converter);
        }
        return converter;
    }

    @Override
    public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
        return this.doLookup(toType, fromType, false);
    }

    protected TypeConverter doLookup(Class<?> toType, Class<?> fromType, boolean isSuper) {
        if (fromType != null) {
            TypeConverter converter = this.getTypeConverter(toType, fromType);
            if (converter != null) {
                return converter;
            }
            for (Class<?> type : fromType.getInterfaces()) {
                converter = this.getTypeConverter(toType, type);
                if (converter == null) continue;
                return converter;
            }
            Class<?> fromSuperClass = fromType.getSuperclass();
            if (fromSuperClass != null && !fromSuperClass.equals(Object.class) && (converter = this.doLookup(toType, fromSuperClass, true)) != null) {
                return converter;
            }
        }
        if (!isSuper && fromType != null && !fromType.equals(Object.class)) {
            Set entries = this.typeMappings.entrySet();
            for (Map.Entry entry : entries) {
                Class<?> aFromType;
                TypeMapping key = (TypeMapping)entry.getKey();
                Class<?> aToType = key.getToType();
                if (!toType.isAssignableFrom(aToType) || (aFromType = key.getFromType()).equals(Object.class) || !aFromType.isAssignableFrom(fromType)) continue;
                return (TypeConverter)entry.getValue();
            }
            TypeConverter converter = this.getTypeConverter(toType, Object.class);
            if (converter != null) {
                return converter;
            }
        }
        return null;
    }

    @Override
    public List<Class<?>[]> listAllTypeConvertersFromTo() {
        ArrayList<Class<?>[]> answer = new ArrayList<Class<?>[]>(this.typeMappings.size());
        for (TypeMapping mapping : this.typeMappings.keySet()) {
            answer.add(new Class[]{mapping.getFromType(), mapping.getToType()});
        }
        return answer;
    }

    public void loadCoreTypeConverters() throws Exception {
        CoreTypeConverterLoader core = new CoreTypeConverterLoader();
        core.load(this);
    }

    protected void loadTypeConverters() throws Exception {
        for (TypeConverterLoader typeConverterLoader : this.getTypeConverterLoaders()) {
            typeConverterLoader.load(this);
        }
        try {
            this.loadFallbackTypeConverters();
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
            // empty catch block
        }
    }

    protected void loadFallbackTypeConverters() throws IOException, ClassNotFoundException {
        List<TypeConverter> converters = this.factoryFinder.newInstances("FallbackTypeConverter", this.getInjector(), TypeConverter.class);
        for (TypeConverter converter : converters) {
            this.addFallbackTypeConverter(converter, false);
        }
    }

    protected TypeConversionException createTypeConversionException(Exchange exchange, Class<?> type, Object value, Throwable cause) {
        Object body = exchange != null ? MessageHelper.extractValueForLogging(value, exchange.getIn()) : value;
        return new TypeConversionException(body, type, cause);
    }

    @Override
    public TypeConverterRegistry.Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public int size() {
        return this.typeMappings.size();
    }

    @Override
    public LoggingLevel getTypeConverterExistsLoggingLevel() {
        return this.typeConverterExistsLoggingLevel;
    }

    @Override
    public void setTypeConverterExistsLoggingLevel(LoggingLevel typeConverterExistsLoggingLevel) {
        this.typeConverterExistsLoggingLevel = typeConverterExistsLoggingLevel;
    }

    @Override
    public TypeConverterExists getTypeConverterExists() {
        return this.typeConverterExists;
    }

    @Override
    public void setTypeConverterExists(TypeConverterExists typeConverterExists) {
        this.typeConverterExists = typeConverterExists;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        if (this.statistics.isStatisticsEnabled()) {
            String info = this.statistics.toString();
            info = info + String.format(" mappings[total=%s, misses=%s]", this.typeMappings.size(), this.misses.size());
            this.log.info(info);
        }
        this.typeMappings.clear();
        this.misses.clear();
        this.statistics.reset();
    }

    protected static class FallbackTypeConverter {
        private final boolean canPromote;
        private final TypeConverter fallbackTypeConverter;

        FallbackTypeConverter(TypeConverter fallbackTypeConverter, boolean canPromote) {
            this.canPromote = canPromote;
            this.fallbackTypeConverter = fallbackTypeConverter;
        }

        public boolean isCanPromote() {
            return this.canPromote;
        }

        public TypeConverter getFallbackTypeConverter() {
            return this.fallbackTypeConverter;
        }
    }

    protected static final class TypeMapping {
        private final Class<?> toType;
        private final Class<?> fromType;
        private final int hashCode;

        TypeMapping(Class<?> toType, Class<?> fromType) {
            this.toType = toType;
            this.fromType = fromType;
            int hash = toType.hashCode();
            if (fromType != null) {
                hash *= 37 + fromType.hashCode();
            }
            this.hashCode = hash;
        }

        public Class<?> getFromType() {
            return this.fromType;
        }

        public Class<?> getToType() {
            return this.toType;
        }

        public boolean equals(Object object) {
            if (object instanceof TypeMapping) {
                TypeMapping that = (TypeMapping)object;
                return this.fromType == that.fromType && this.toType == that.toType;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "[" + this.fromType + "=>" + this.toType + "]";
        }

        public boolean isApplicable(Class<?> fromClass) {
            return this.fromType.isAssignableFrom(fromClass);
        }
    }

    private final class UtilizationStatistics
    implements TypeConverterRegistry.Statistics {
        private boolean statisticsEnabled;

        private UtilizationStatistics() {
        }

        @Override
        public long getNoopCounter() {
            return BaseTypeConverterRegistry.this.noopCounter.longValue();
        }

        @Override
        public long getAttemptCounter() {
            return BaseTypeConverterRegistry.this.attemptCounter.longValue();
        }

        @Override
        public long getHitCounter() {
            return BaseTypeConverterRegistry.this.hitCounter.longValue();
        }

        @Override
        public long getBaseHitCounter() {
            return BaseTypeConverterRegistry.this.baseHitCounter.longValue();
        }

        @Override
        public long getMissCounter() {
            return BaseTypeConverterRegistry.this.missCounter.longValue();
        }

        @Override
        public long getFailedCounter() {
            return BaseTypeConverterRegistry.this.failedCounter.longValue();
        }

        @Override
        public void reset() {
            BaseTypeConverterRegistry.this.noopCounter.reset();
            BaseTypeConverterRegistry.this.attemptCounter.reset();
            BaseTypeConverterRegistry.this.hitCounter.reset();
            BaseTypeConverterRegistry.this.baseHitCounter.reset();
            BaseTypeConverterRegistry.this.missCounter.reset();
            BaseTypeConverterRegistry.this.failedCounter.reset();
        }

        @Override
        public boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        @Override
        public void setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
        }

        public String toString() {
            return String.format("TypeConverterRegistry utilization[noop=%s, attempts=%s, hits=%s, baseHits=%s, misses=%s, failures=%s]", this.getNoopCounter(), this.getAttemptCounter(), this.getHitCounter(), this.getBaseHitCounter(), this.getMissCounter(), this.getFailedCounter());
        }
    }
}

