/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.CamelLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelLogProcessor
implements AsyncProcessor,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelLogProcessor.class);
    private String id;
    private CamelLogger log;
    private ExchangeFormatter formatter = new ToStringExchangeFormatter();
    private MaskingFormatter maskingFormatter;
    private Set<LogListener> listeners;

    public CamelLogProcessor() {
        this(new CamelLogger(CamelLogProcessor.class.getName()));
    }

    public CamelLogProcessor(CamelLogger log) {
        this.log = log;
    }

    public CamelLogProcessor(CamelLogger log, ExchangeFormatter formatter, MaskingFormatter maskingFormatter, Set<LogListener> listeners) {
        this(log);
        this.formatter = formatter;
        this.maskingFormatter = maskingFormatter;
        this.listeners = listeners;
    }

    public String toString() {
        return "Logger[" + this.log + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.log.shouldLog()) {
            String output = this.formatter.format(exchange);
            if (this.maskingFormatter != null) {
                output = this.maskingFormatter.format(output);
            }
            output = this.fireListeners(exchange, output);
            this.log.log(output);
        }
        callback.done(true);
        return true;
    }

    public void process(Exchange exchange, Throwable exception) {
        if (this.log.shouldLog()) {
            String output = this.formatter.format(exchange);
            if (this.maskingFormatter != null) {
                output = this.maskingFormatter.format(output);
            }
            output = this.fireListeners(exchange, output);
            this.log.log(output, exception);
        }
    }

    public void process(Exchange exchange, String message) {
        if (this.log.shouldLog()) {
            String output = this.formatter.format(exchange) + message;
            if (this.maskingFormatter != null) {
                output = this.maskingFormatter.format(output);
            }
            output = this.fireListeners(exchange, output);
            this.log.log(output);
        }
    }

    private String fireListeners(Exchange exchange, String message) {
        if (this.listeners == null) {
            return message;
        }
        for (LogListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                String output = listener.onLog(exchange, this.log, message);
                message = output != null ? output : message;
            }
            catch (Throwable t) {
                LOG.warn("Ignoring an exception thrown by {}: {}", (Object)listener.getClass().getName(), (Object)t.getMessage());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("", t);
            }
        }
        return message;
    }

    public CamelLogger getLogger() {
        return this.log;
    }

    public void setLogName(String logName) {
        this.log.setLogName(logName);
    }

    public void setLevel(LoggingLevel level) {
        this.log.setLevel(level);
    }

    public void setMarker(String marker) {
        this.log.setMarker(marker);
    }

    public void setMaskingFormatter(MaskingFormatter maskingFormatter) {
        this.maskingFormatter = maskingFormatter;
    }

    static class ToStringExchangeFormatter
    implements ExchangeFormatter {
        ToStringExchangeFormatter() {
        }

        @Override
        public String format(Exchange exchange) {
            return exchange.toString();
        }
    }
}

