/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.internal.networking.ChannelInitializerProvider;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.spi.discovery.integration.DiscoveryService;

public class CandidateClusterContext {
    private final AddressProvider addressProvider;
    private final AddressTranslator addressTranslator;
    private final DiscoveryService discoveryService;
    private final ICredentialsFactory credentialsFactory;
    private final SocketInterceptor socketInterceptor;
    private final ChannelInitializerProvider channelInitializerProvider;

    public CandidateClusterContext(AddressProvider addressProvider, AddressTranslator addressTranslator, DiscoveryService discoveryService, ICredentialsFactory credentialsFactory, SocketInterceptor socketInterceptor, ChannelInitializerProvider channelInitializerProvider) {
        this.addressProvider = addressProvider;
        this.addressTranslator = addressTranslator;
        this.discoveryService = discoveryService;
        this.credentialsFactory = credentialsFactory;
        this.socketInterceptor = socketInterceptor;
        this.channelInitializerProvider = channelInitializerProvider;
    }

    public void start() {
        if (this.discoveryService != null) {
            this.discoveryService.start();
        }
    }

    public ICredentialsFactory getCredentialsFactory() {
        return this.credentialsFactory;
    }

    public void destroy() {
        if (this.discoveryService != null) {
            this.discoveryService.destroy();
        }
    }

    public AddressProvider getAddressProvider() {
        return this.addressProvider;
    }

    public AddressTranslator getAddressTranslator() {
        return this.addressTranslator;
    }

    public SocketInterceptor getSocketInterceptor() {
        return this.socketInterceptor;
    }

    public String getName() {
        return this.credentialsFactory.newCredentials().getPrincipal();
    }

    public ChannelInitializerProvider getChannelInitializerProvider() {
        return this.channelInitializerProvider;
    }
}

