/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching;

import java.util.regex.Pattern;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.ResourceUrl;
import org.apache.wicket.request.resource.caching.version.CachingResourceVersion;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilenameWithVersionResourceCachingStrategy
implements IResourceCachingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FilenameWithVersionResourceCachingStrategy.class);
    private static final String DEFAULT_VERSION_PREFIX = "-ver-";
    private final String versionPrefix;
    private final IResourceVersion resourceVersion;

    public FilenameWithVersionResourceCachingStrategy(IResourceVersion resourceVersion) {
        this(DEFAULT_VERSION_PREFIX, resourceVersion);
    }

    public FilenameWithVersionResourceCachingStrategy(String versionPrefix, IResourceVersion resourceVersion) {
        this.resourceVersion = (IResourceVersion)Args.notNull((Object)resourceVersion, (String)"resourceVersion");
        this.versionPrefix = Args.notEmpty((String)versionPrefix, (String)"versionPrefix");
    }

    public final String getVersionPrefix() {
        return this.versionPrefix;
    }

    @Override
    public void decorateUrl(ResourceUrl url, IStaticCacheableResource resource) {
        String version = this.resourceVersion.getVersion(resource);
        if (version == null) {
            return;
        }
        String filename = url.getFileName();
        int extensionAt = filename.lastIndexOf(46);
        StringBuilder versionedFilename = new StringBuilder();
        if (extensionAt == -1) {
            versionedFilename.append(filename);
        } else {
            versionedFilename.append(filename.substring(0, extensionAt));
        }
        int pos = versionedFilename.indexOf(this.getVersionPrefix());
        if (pos != -1 && this.isVersion(versionedFilename.substring(pos + this.versionPrefix.length()))) {
            LOG.error("A resource with name '{}' contains the version prefix '{}' so the un-decoration will not work. Either use a different version prefix or rename this resource.", (Object)filename, (Object)this.getVersionPrefix());
        }
        versionedFilename.append(this.versionPrefix);
        versionedFilename.append(version);
        if (extensionAt != -1) {
            versionedFilename.append(filename.substring(extensionAt));
        }
        url.setFileName(versionedFilename.toString());
    }

    @Override
    public void undecorateUrl(ResourceUrl url) {
        String filename = url.getFileName();
        int pos = filename.lastIndexOf(46);
        String fullname = pos == -1 ? filename : filename.substring(0, pos);
        String extension = pos == -1 ? null : filename.substring(pos);
        pos = fullname.lastIndexOf(this.versionPrefix);
        if (pos != -1 && this.isVersion(fullname.substring(pos + this.versionPrefix.length()))) {
            String basename = fullname.substring(0, pos);
            url.setFileName((String)(extension == null ? basename : basename + extension));
            RequestCycle requestCycle = RequestCycle.get();
            if (requestCycle != null) {
                int idx = fullname.indexOf(this.versionPrefix);
                String urlVersion = fullname.substring(idx + this.versionPrefix.length());
                requestCycle.setMetaData(URL_VERSION, urlVersion);
            }
        }
    }

    private boolean isVersion(String substring) {
        Pattern versionPattern = this.resourceVersion.getVersionPattern();
        return versionPattern == null || versionPattern.matcher(substring).matches();
    }

    @Override
    public void decorateResponse(AbstractResource.ResourceResponse response, IStaticCacheableResource resource) {
        String requestedVersion = (String)RequestCycle.get().getMetaData(URL_VERSION);
        String calculatedVersion = this.resourceVersion.getVersion(resource);
        if (calculatedVersion != null && calculatedVersion.equals(requestedVersion)) {
            response.setCacheDurationToMaximum();
            response.setCacheScope(WebResponse.CacheScope.PUBLIC);
        }
    }

    @Override
    public void clearCache() {
        if (this.resourceVersion instanceof CachingResourceVersion) {
            ((CachingResourceVersion)this.resourceVersion).invalidateAll();
        }
    }
}

