/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.palette.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class Recorder<T>
extends HiddenField<String> {
    private static final long serialVersionUID = 1L;
    private final Palette<T> palette;

    public Recorder(String id, Palette<T> palette) {
        super(id, (IModel)new Model());
        this.palette = palette;
        this.setOutputMarkupId(true);
    }

    public Palette<T> getPalette() {
        return this.palette;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.initIds();
    }

    private void initIds() {
        IChoiceRenderer<T> renderer = this.getPalette().getChoiceRenderer();
        StringBuilder modelStringBuffer = new StringBuilder();
        Collection<T> modelCollection = this.getPalette().getModelCollection();
        if (modelCollection == null) {
            throw new WicketRuntimeException("Expected getPalette().getModelCollection() to return a non-null value. Please make sure you have model object assigned to the palette");
        }
        Iterator<T> selection = modelCollection.iterator();
        int i = 0;
        while (selection.hasNext()) {
            modelStringBuffer.append(renderer.getIdValue(selection.next(), i++));
            if (!selection.hasNext()) continue;
            modelStringBuffer.append(',');
        }
        String modelString = modelStringBuffer.toString();
        this.setModelObject(modelString);
    }

    public List<T> getSelectedList() {
        IChoiceRenderer<T> renderer = this.getPalette().getChoiceRenderer();
        Collection<T> choices = this.getPalette().getChoices();
        ArrayList<T> selected = new ArrayList<T>(choices.size());
        HashMap<T, String> idForChoice = new HashMap<T, String>(choices.size());
        for (T choice : choices) {
            idForChoice.put(choice, renderer.getIdValue(choice, 0));
        }
        block1: for (String id : Strings.split((String)this.getValue(), (char)',')) {
            for (T choice : choices) {
                String idValue = (String)idForChoice.get(choice);
                if (!id.equals(idValue)) continue;
                selected.add(choice);
                continue block1;
            }
        }
        return selected;
    }

    public List<T> getUnselectedList() {
        IChoiceRenderer<T> renderer = this.getPalette().getChoiceRenderer();
        Collection<T> choices = this.getPalette().getChoices();
        ArrayList<T> unselected = new ArrayList<T>(choices.size());
        TreeSet<String> ids = new TreeSet<String>(Arrays.asList(Strings.split((String)this.getValue(), (char)',')));
        for (T choice : choices) {
            String choiceId = renderer.getIdValue(choice, 0);
            if (ids.contains(choiceId)) continue;
            unselected.add(choice);
        }
        return unselected;
    }
}

