/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.bean.validation;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.wicket.bean.validation.IViolationTranslator;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.ValidationError;

public class DefaultViolationTranslator
implements IViolationTranslator {
    @Override
    public <T> ValidationError convert(ConstraintViolation<T> violation) {
        ConstraintDescriptor desc = violation.getConstraintDescriptor();
        ValidationError error = new ValidationError();
        error.setMessage(violation.getMessage());
        List<String> messages = this.getViolationMessages(violation, desc);
        this.addErrorKeys(error, violation.getInvalidValue(), messages);
        for (String key : desc.getAttributes().keySet()) {
            error.setVariable(key, desc.getAttributes().get(key));
        }
        return error;
    }

    private List<String> getViolationMessages(ConstraintViolation<?> violation, ConstraintDescriptor<?> desc) {
        String defaultMessage = (String)desc.getAttributes().get("message");
        String violationMessage = violation.getMessage();
        String violationMessageTemplate = violation.getMessageTemplate();
        ArrayList<String> messages = new ArrayList<String>();
        if (!Strings.isEqual((String)violationMessage, (String)violationMessageTemplate)) {
            messages.add(violationMessageTemplate);
        }
        messages.add(violationMessage);
        if (!Strings.isEqual((String)defaultMessage, (String)violationMessageTemplate)) {
            messages.add(defaultMessage);
        }
        return messages;
    }

    private void addErrorKeys(ValidationError error, Object invalidValue, List<String> messages) {
        for (String message : messages) {
            String messageKey = this.getMessageKey(message);
            if (messageKey == null) continue;
            if (invalidValue != null) {
                error.addKey(messageKey + "." + invalidValue.getClass().getSimpleName());
            }
            error.addKey(messageKey);
        }
    }

    private String getMessageKey(String message) {
        if (!Strings.isEmpty((String)message) && message.startsWith("{") && message.endsWith("}")) {
            return message.substring(1, message.length() - 1);
        }
        return null;
    }
}

