/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.debug;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public final class PageView
extends Panel {
    public static final MetaDataKey<Long> RENDER_KEY = new MetaDataKey<Long>(){};
    private static final long serialVersionUID = 1L;

    public PageView(String id, Page page) {
        super(id);
        this.add(new Label("info", (Serializable)((Object)(page == null ? "[Stateless Page]" : page.toString()))));
        List data = null;
        String pageRenderDuration = "n/a";
        if (page != null) {
            Long renderTime = (Long)page.getMetaData((MetaDataKey)RENDER_KEY);
            if (renderTime != null) {
                pageRenderDuration = renderTime.toString();
            }
            data = new ArrayList<ComponentData>(this.getComponentData(page));
            Collections.sort(data, new Comparator<ComponentData>(){

                @Override
                public int compare(ComponentData o1, ComponentData o2) {
                    return o1.path.compareTo(o2.path);
                }
            });
        } else {
            data = Collections.emptyList();
        }
        this.add(new Label("pageRenderDuration", (Serializable)((Object)pageRenderDuration)));
        this.add(new ListView<ComponentData>("components", data){
            private static final long serialVersionUID = 1L;

            @Override
            protected void populateItem(ListItem<ComponentData> listItem) {
                ComponentData componentData = (ComponentData)listItem.getModelObject();
                listItem.add(new Label("row", (Serializable)((Object)Long.toString(listItem.getIndex() + 1))));
                listItem.add(new Label("path", (Serializable)((Object)componentData.path)));
                listItem.add(new Label("size", (Serializable)((Object)Bytes.bytes(componentData.size).toString())));
                listItem.add(new Label("type", (Serializable)((Object)componentData.type)));
                listItem.add(new Label("model", (Serializable)((Object)componentData.value)));
                listItem.add(new Label("renderDuration", (Serializable)((Object)(componentData.renderDuration != null ? componentData.renderDuration.toString() : "n/a"))));
            }
        });
    }

    private List<ComponentData> getComponentData(Page page) {
        final ArrayList<ComponentData> data = new ArrayList<ComponentData>();
        page.visitChildren(new IVisitor<Component, Void>(){

            @Override
            public void component(Component component, IVisit<Void> visit) {
                if (!component.getPath().startsWith(PageView.this.getPath())) {
                    String name = component.getClass().getName();
                    if (name.indexOf("$") > 0) {
                        name = component.getClass().getSuperclass().getName();
                    }
                    name = Strings.lastPathComponent(name, ':');
                    ComponentData componentData = new ComponentData(component.getPageRelativePath(), name, component.getSizeInBytes());
                    Long renderDuration = (Long)component.getMetaData((MetaDataKey)RENDER_KEY);
                    if (renderDuration != null) {
                        componentData.renderDuration = renderDuration;
                    }
                    try {
                        componentData.value = component.getDefaultModelObjectAsString();
                    }
                    catch (Exception e) {
                        componentData.value = e.getMessage();
                    }
                    data.add(componentData);
                }
            }
        });
        return data;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render(CssHeaderItem.forReference(new CssResourceReference(PageView.class, "pageview.css")));
    }

    private static class ComponentData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        public final String path;
        public final String type;
        public String value;
        public final long size;
        private Long renderDuration;

        ComponentData(String path, String type, long size) {
            this.path = path;
            this.type = type;
            this.size = size;
        }
    }
}

