/*
 * MultiProxyHandler.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 1998-2002 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): cstevens, suhler.
 *
 * Version:  2.1
 * Created by suhler on 98/09/21
 * Last modified by suhler on 02/10/01 16:36:24
 */

package sunlabs.brazil.handler;

import sunlabs.brazil.server.Server;
import java.util.Hashtable;

/**
 * Handler for permitting multiple cross connected virtual web sites.
 * Each handler instance adds its prefix and destination to a
 * static hashtable so the URL rewrite rules rewrite all of them correctly.
 * <p>
 * The
 * {@link GenericProxyHandler}
 * rewrites all of the links in each wepage to point back to the local.
 * machine.  Using this handler, if multiple virtual websites are configured, 
 * then links in one site that point to other virtual web sites are
 * rewritten to point locally as well.
 * <p>
 * For example, suppose we have 2  MultiProxyhandlers A and B configured
 * into the server as:
 * <ul>
 * <br><code>A.prefix=/foo/</code>
 * <br><code>A.host=www.foo.com</code>
 * <br><code>B.prefix=/bar/</code>
 * <br><code>B.host=www.bar.com</code>.
 * </ul>
 * A local request for <code>/foo/bar/test.html</code> will fetch
 * <code>http://www.foo.com/bar/test.html</code>.  If the result is
 * an html page, then any links in that page that resolve to
 * <code>www.foo.com/...</code> will be rewritten to the local server
 * as <code>/foo/...</code>, and any links that points to
 * <code>www.bar.com/...</code> will be rewritten to
 * <code>/bar/...</code>.
 *
 * @author      Stephen Uhler
 * @version	2.1, 02/10/01
 */

public class MultiProxyHandler extends GenericProxyHandler {

    /* XXX This shouldn't be global; instead there should be a 
     *	   per-server hashtable (sau)
     */
    /**
     * Holds all proxy -> prefix mappings for this server.
     */
    public static Hashtable proxies = null;

    /**
     * Initialize this handler.
     * Add rewrite mapping into the global table.
     * If any "virtual" web sites reference other "virtual" web sites, then
     * rewrite the links accordingly.
     */

    public boolean
    init(Server server, String prefix) {
    	if (!super.init(server,prefix)) {
	    return false;
	}
	if (proxies == null) {
	    proxies = new Hashtable(17);
	}
	String map = "http://" + host + ":" + port + "/";

	/*
	 * No good reason not to allow this, other then to prevent confusion
	 */

	if (proxies.containsKey(map)) {
	    server.log(Server.LOG_WARNING, prefix,
		    "Prefix already in use: " + map + " -> " +
		    proxies.get(map));
	    return false;
	}
	proxies.put(map, urlPrefix);
	if (map.endsWith(":80/")) {
	    proxies.put(map.substring(0,map.length()-4) + "/", urlPrefix);
	}

	server.log(Server.LOG_INFORMATIONAL, prefix, "proxies: " + proxies);
	return true;
    }

    /**
     * this gets called by the parent class.
     */

    public void addMap(MapPage map) {
        map.setMap(proxies);
    }
}
