﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/amp/PrometheusService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace PrometheusService {
namespace Model {

/**
 * <p>Configuration settings for a scraper component.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ComponentConfig">AWS
 * API Reference</a></p>
 */
class ComponentConfig {
 public:
  AWS_PROMETHEUSSERVICE_API ComponentConfig() = default;
  AWS_PROMETHEUSSERVICE_API ComponentConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROMETHEUSSERVICE_API ComponentConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROMETHEUSSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Configuration options for the scraper component.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetOptions() const { return m_options; }
  inline bool OptionsHasBeenSet() const { return m_optionsHasBeenSet; }
  template <typename OptionsT = Aws::Map<Aws::String, Aws::String>>
  void SetOptions(OptionsT&& value) {
    m_optionsHasBeenSet = true;
    m_options = std::forward<OptionsT>(value);
  }
  template <typename OptionsT = Aws::Map<Aws::String, Aws::String>>
  ComponentConfig& WithOptions(OptionsT&& value) {
    SetOptions(std::forward<OptionsT>(value));
    return *this;
  }
  template <typename OptionsKeyT = Aws::String, typename OptionsValueT = Aws::String>
  ComponentConfig& AddOptions(OptionsKeyT&& key, OptionsValueT&& value) {
    m_optionsHasBeenSet = true;
    m_options.emplace(std::forward<OptionsKeyT>(key), std::forward<OptionsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Map<Aws::String, Aws::String> m_options;
  bool m_optionsHasBeenSet = false;
};

}  // namespace Model
}  // namespace PrometheusService
}  // namespace Aws
