/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.InjectSecurity;

public abstract class SafeSecurityInjector
implements AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(SafeSecurityInjector.class);
    private static final String OPENDISTRO_SECURITY_USER = "_opendistro_security_user";
    private InjectSecurity rolesInjectorHelper;
    protected String id;
    protected Settings settings;
    protected ThreadContext tc;

    public SafeSecurityInjector(String id, Settings settings, ThreadContext tc) {
        this.id = id;
        this.settings = settings;
        this.tc = tc;
        this.rolesInjectorHelper = null;
    }

    protected boolean shouldInject() {
        if (this.id == null || this.settings == null || this.tc == null) {
            LOG.debug(String.format(Locale.ROOT, "null value: id: %s, settings: %s, threadContext: %s", this.id, this.settings, this.tc));
            return false;
        }
        Object userIn = this.tc.getTransient(OPENDISTRO_SECURITY_USER);
        if (userIn != null) {
            LOG.debug((Message)new ParameterizedMessage("User not empty in thread context: [{}]", userIn));
            return false;
        }
        userIn = this.tc.getTransient("_opendistro_security_user_info");
        if (userIn != null) {
            LOG.debug((Message)new ParameterizedMessage("User not empty in thread context: [{}]", userIn));
            return false;
        }
        Object rolesin = this.tc.getTransient("opendistro_security_injected_roles");
        if (rolesin != null) {
            LOG.warn((Message)new ParameterizedMessage("Injected roles not empty in thread context: [{}]", rolesin));
            return false;
        }
        return true;
    }

    protected void inject(String user, List<String> roles) {
        if (roles == null) {
            LOG.warn("Cannot inject empty roles in thread context");
            return;
        }
        if (this.rolesInjectorHelper == null) {
            this.rolesInjectorHelper = new InjectSecurity(this.id, this.settings, this.tc);
        }
        this.rolesInjectorHelper.inject(user, roles);
    }

    @Override
    public void close() {
        if (this.rolesInjectorHelper != null) {
            this.rolesInjectorHelper.close();
        }
    }
}

