/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification;

import org.tribuo.classification.Classifiable;

public final class Label
implements Classifiable<Label> {
    private static final long serialVersionUID = 1L;
    public static final String UNKNOWN = "LABEL##UNKNOWN";
    protected final String label;
    protected final double score;

    public Label(String label, double score) {
        this.label = label;
        this.score = score;
    }

    public Label(String label) {
        this(label, Double.NaN);
    }

    public double getScore() {
        return this.score;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Label)) {
            return false;
        }
        Label that = (Label)o;
        return this.label != null ? this.label.equals(that.label) : that.label == null;
    }

    public boolean fullEquals(Label o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(Double.isNaN(o.score) && Double.isNaN(this.score) || Double.compare(o.score, this.score) == 0)) {
            return false;
        }
        return this.label != null ? this.label.equals(o.label) : o.label == null;
    }

    public int hashCode() {
        int result = this.label.hashCode();
        return result;
    }

    public String toString() {
        if (Double.isNaN(this.score)) {
            return this.label;
        }
        return "(" + this.label + "," + this.score + ")";
    }

    public Label copy() {
        return new Label(this.label, this.score);
    }

    public String getSerializableForm(boolean includeConfidence) {
        if (includeConfidence && !Double.isNaN(this.score)) {
            return this.label + ",score=" + this.score;
        }
        return this.label;
    }
}

