/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchpipelines.questionanswering.generative.llm;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;

public class MessageBlock
implements Writeable,
ToXContent {
    private static final String TEXT_BLOCK = "text";
    private static final String IMAGE_BLOCK = "image";
    private static final String DOCUMENT_BLOCK = "document";
    private String role;
    private List<AbstractBlock> blockList = new ArrayList<AbstractBlock>();

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.role);
        out.writeList(this.blockList);
    }

    public MessageBlock(StreamInput in) throws IOException {
        this.role = in.readString();
        Writeable.Reader reader = input -> {
            String type = input.readString();
            if (type.equals(TEXT_BLOCK)) {
                return new TextBlock(input);
            }
            if (type.equals(IMAGE_BLOCK)) {
                return new ImageBlock(input);
            }
            if (type.equals(DOCUMENT_BLOCK)) {
                return new DocumentBlock(input);
            }
            throw new RuntimeException("Unexpected type: " + type);
        };
        this.blockList = in.readList(reader);
    }

    public static MessageBlock fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return new MessageBlock(parser.map());
        }
        throw new XContentParseException(parser.getTokenLocation(), "Expected [START_OBJECT], got " + String.valueOf(parser.currentToken()));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("role", this.role);
        builder.startArray("content");
        for (AbstractBlock block : this.blockList) {
            block.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public MessageBlock() {
    }

    public MessageBlock(Map<String, ?> map) {
        this.setMessageBlock(map);
    }

    public void setMessageBlock(Map<String, ?> message) {
        Preconditions.checkNotNull(message, (Object)"message cannot be null.");
        Preconditions.checkState((boolean)message.containsKey("role"), (Object)"message must have role.");
        Preconditions.checkState((boolean)message.containsKey("content"), (Object)"message must have content.");
        this.role = (String)message.get("role");
        List contents = (List)message.get("content");
        for (Map content : contents) {
            if (content.containsKey(TEXT_BLOCK)) {
                this.blockList.add(new TextBlock((String)content.get(TEXT_BLOCK)));
                continue;
            }
            if (content.containsKey(IMAGE_BLOCK)) {
                Map imageBlock = (Map)content.get(IMAGE_BLOCK);
                this.blockList.add(new ImageBlock(imageBlock));
                continue;
            }
            if (!content.containsKey(DOCUMENT_BLOCK)) continue;
            Map documentBlock = (Map)content.get(DOCUMENT_BLOCK);
            this.blockList.add(new DocumentBlock(documentBlock));
        }
    }

    public boolean equals(Object o) {
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.role) + Objects.hashCode(this.blockList);
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public List<AbstractBlock> getBlockList() {
        return this.blockList;
    }

    @Generated
    public void setBlockList(List<AbstractBlock> blockList) {
        this.blockList = blockList;
    }

    public static abstract class AbstractBlock
    implements Block,
    Writeable,
    ToXContent {
        @Override
        public abstract String getType();

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }

    public static class TextBlock
    extends AbstractBlock {
        String type = "text";
        String text;

        public TextBlock(String text) {
            Preconditions.checkNotNull((Object)text, (Object)"text cannot be null.");
            this.text = text;
        }

        public TextBlock(StreamInput in) throws IOException {
            this.text = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeString(this.text);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", MessageBlock.TEXT_BLOCK);
            builder.field(MessageBlock.TEXT_BLOCK, this.text);
            builder.endObject();
            return builder;
        }

        @Override
        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public void setText(String text) {
            this.text = text;
        }
    }

    public static class ImageBlock
    extends AbstractBlock {
        String type = "image";
        String format;
        String data;
        String url;

        public ImageBlock(Map<String, ?> imageBlock) {
            this.format = (String)imageBlock.get("format");
            Object tmp = imageBlock.get("data");
            if (tmp != null) {
                this.data = (String)tmp;
            } else {
                tmp = imageBlock.get("url");
                if (tmp == null) {
                    throw new IllegalArgumentException("data or url not found in imageBlock.");
                }
                this.url = (String)tmp;
            }
        }

        public ImageBlock(String format, String data, String url) {
            Preconditions.checkNotNull((Object)format, (Object)"format cannot be null.");
            if (data == null && url == null) {
                throw new IllegalArgumentException("data and url cannot both be null.");
            }
            this.format = format;
            this.data = data;
            this.url = url;
        }

        public ImageBlock(StreamInput in) throws IOException {
            this.format = in.readString();
            this.data = in.readOptionalString();
            this.url = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeString(this.format);
            out.writeOptionalString(this.data);
            out.writeOptionalString(this.url);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            HashMap<String, String> imageMap = new HashMap<String, String>();
            imageMap.put("format", this.format);
            if (this.data != null) {
                imageMap.put("data", this.data);
            } else if (this.url != null) {
                imageMap.put("url", this.url);
            }
            builder.field(MessageBlock.IMAGE_BLOCK, imageMap);
            builder.endObject();
            return builder;
        }

        @Override
        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getFormat() {
            return this.format;
        }

        @Generated
        public void setFormat(String format) {
            this.format = format;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public void setData(String data) {
            this.data = data;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class DocumentBlock
    extends AbstractBlock {
        String type = "document";
        String format;
        String name;
        String data;

        public DocumentBlock(Map<String, ?> documentBlock) {
            Preconditions.checkState((boolean)documentBlock.containsKey("format"), (Object)"format not found in the document block.");
            Preconditions.checkState((boolean)documentBlock.containsKey("name"), (Object)"name not found in the document block.");
            Preconditions.checkState((boolean)documentBlock.containsKey("data"), (Object)"data not found in the document block");
            this.format = (String)documentBlock.get("format");
            this.name = (String)documentBlock.get("name");
            this.data = (String)documentBlock.get("data");
        }

        public DocumentBlock(String format, String name, String data) {
            Preconditions.checkNotNull((Object)format, (Object)"format cannot be null.");
            Preconditions.checkNotNull((Object)name, (Object)"name cannot be null.");
            Preconditions.checkNotNull((Object)data, (Object)"data cannot be null.");
            this.format = format;
            this.name = name;
            this.data = data;
        }

        public DocumentBlock(StreamInput in) throws IOException {
            this.format = in.readString();
            this.name = in.readString();
            this.data = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeString(this.format);
            out.writeString(this.name);
            out.writeString(this.data);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject(MessageBlock.DOCUMENT_BLOCK);
            builder.field("format", this.format);
            builder.field("name", this.name);
            builder.field("data", this.data);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        @Override
        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getFormat() {
            return this.format;
        }

        @Generated
        public void setFormat(String format) {
            this.format = format;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public void setData(String data) {
            this.data = data;
        }
    }

    public static interface Block {
        public String getType();
    }
}

